/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmCommon;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.AsmSettings;
import com.avaya.asm.core.Description;
import com.avaya.asm.core.Limits;
import com.avaya.asm.core.LocalSettings;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.datamgr.BLDMEnumType;
import com.avaya.asm.datamgr.BusinessLogicDM;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DMListener;
import com.avaya.asm.datamgr.DMUtilities;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.DebugDMAppBase;
import com.avaya.asm.datamgr.NameResolutionDM;
import com.avaya.asm.datamgr.dao.AppSetDAO;
import com.avaya.asm.datamgr.dao.AppSetPatternDAO;
import com.avaya.asm.datamgr.dao.AsmCommProfileDAO;
import com.avaya.asm.datamgr.dao.AsmInstanceDAO;
import com.avaya.asm.datamgr.dao.AusCommProfileDAO;
import com.avaya.asm.datamgr.dao.CPDeviceSettingsDAO;
import com.avaya.asm.datamgr.dao.CmCommProfileDAO;
import com.avaya.asm.datamgr.dao.CsDomainDAO;
import com.avaya.asm.datamgr.dao.CsHandleDAO;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.DigitMapRouterDAO;
import com.avaya.asm.datamgr.dao.EntityLinkTableDAO;
import com.avaya.asm.datamgr.dao.EventDAO;
import com.avaya.asm.datamgr.dao.GlobalDAO;
import com.avaya.asm.datamgr.dao.HostNameDAO;
import com.avaya.asm.datamgr.dao.LocationDAO;
import com.avaya.asm.datamgr.dao.LocationPatternDAO;
import com.avaya.asm.datamgr.dao.PsCommProfileDAO;
import com.avaya.asm.datamgr.dao.RoutePolicyDAO;
import com.avaya.asm.datamgr.dao.SIPDomainDAO;
import com.avaya.asm.datamgr.dao.SIPEntityDAO;
import com.avaya.asm.datamgr.dao.SetCommunityDAO;
import com.avaya.asm.datamgr.dao.SetSurvivableDAO;
import com.avaya.asm.datamgr.dao.TimeDAO;
import com.avaya.asm.datamgr.dao.UserCommunityDAO;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEventList;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationListener;
import com.avaya.asm.datamgr.datadistributionlayer.DDLInterClusterMember;
import com.avaya.asm.datamgr.datadistributionlayer.DDLIntraClusterMember;
import com.avaya.asm.datamgr.datadistributionlayer.DDLUtilities;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerData;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerFactory;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerListener;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMember;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMemberAddr;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMessage;
import com.avaya.asm.datamgr.datadistributionlayer.GroupCommIntf;
import com.avaya.asm.datamgr.datadistributionlayer.JGroupEncoderDecoder;
import com.avaya.asm.datamgr.dynamic.PerformanceMonitoringDDM;
import com.avaya.asm.datamgr.objectapi.Location;
import com.avaya.asm.datamgr.objectapi.SIPEntity;
import com.avaya.asm.datamgr.objectapi.WeakHashSet;
import com.avaya.asm.datamgr.tools.MemoryCounter;
import com.avaya.asm.datamgr.tools.SMConsoleCommand;
import com.avaya.asm.datamgr.tools.SMConsoleListener;
import com.avaya.common.logging.client.Logger;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class DebugDM
extends BusinessLogicDM
implements DataDistLayerListener {
    private final Logger log = AsmLogger.getLogger(DebugDM.class);
    protected static DMFactory factory;
    protected static final String DISTR_SETTING_DELIM = "->";
    private Set<DebugDMAppBase> listeners = new WeakHashSet<DebugDMAppBase>();

    protected DDLIntraClusterMember getMember() {
        return DataDistLayerFactory.getInstance().getIntraClusterMember();
    }

    protected DataDistLayerFactory getDDLFactory() {
        return DataDistLayerFactory.getInstance();
    }

    @Override
    public EnumSet<? extends BLDMEnumType> getDMUsages() {
        return EnumSet.allOf(debugDM.class);
    }

    public static DMFactory getDMFactory() {
        if (factory == null) {
            factory = DMFactory.getInstance();
        }
        return factory;
    }

    @Override
    public void init() {
        this.log.info((Object)"Started initializing DebugDM");
        DataMgr.Status status = DataMgr.Status.OKAY;
        this.setStatus(status);
        this.log.info((Object)("Finished initializing DebugDM with status " + (Object)((Object)status)));
    }

    @SMConsole(description="Log the passed-in string at INFO-level in the SM debug log. This capability exists to enhance log parsing by injecting checkpoints.")
    public String log(String ... strings) {
        StringBuffer logString = new StringBuffer();
        boolean first = true;
        for (String string : strings) {
            if (!first) {
                logString.append(" ");
            }
            logString.append(string);
            first = false;
        }
        this.log.info((Object)logString);
        return logString.toString();
    }

    @SMConsole
    public String reinitAllDAOs() {
        this.log.info((Object)"Re-initing DebugDM - All DAOs");
        HashSet<DataAccessObject> daos = new HashSet<DataAccessObject>();
        for (Class<? extends DataAccessObject> dao : DebugDM.getDMFactory().getAllDAOClasses()) {
            DataAccessObject daoInstance = (DataAccessObject)DebugDM.getDMFactory().getDataMgr(dao);
            daos.add(daoInstance);
        }
        return this.doReinitDAOs(daos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doReinitDAOs(Set<DataAccessObject> daos) {
        StringBuilder processedDAOs = new StringBuilder("Re-init complete:");
        ArrayList<String> results = new ArrayList<String>();
        ClassLoader origCl = Thread.currentThread().getContextClassLoader();
        for (DataAccessObject dao : daos) {
            DataMgr.Status ret = DataMgr.Status.FAIL;
            try {
                ClassLoader curDAOCL = dao.getClass().getClassLoader();
                Thread.currentThread().setContextClassLoader(curDAOCL);
                ret = dao.reinit();
            }
            finally {
                Thread.currentThread().setContextClassLoader(origCl);
            }
            results.add(dao.getClass().getSimpleName() + " " + (Object)((Object)ret));
        }
        Collections.sort(results);
        for (String result : results) {
            processedDAOs.append("\n  " + result);
        }
        return processedDAOs.toString();
    }

    @SMConsole(description="Retrieve the DDL key map for this connected host.  The entire map can be obtained by connecting to the Leader")
    public Object getDDLKeyMap() {
        DataDistLayerMessage message = new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.INTERNAL, 4, null);
        DDLIntraClusterMember member = this.getMember();
        return member.handleQuery(message, null);
    }

    @SMConsole(description="Retrieve the list of Hosts that own data within DDL")
    public Object getDDLHosts() {
        DataDistLayerMessage message = new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.INTERNAL, 3, null);
        DDLIntraClusterMember member = this.getMember();
        Map hostIdKeys = (Map)member.handleQuery(message, null);
        if (hostIdKeys == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("DDL Hosts:\n");
        for (Map.Entry e : hostIdKeys.entrySet()) {
            sb.append("\t" + ((DataDistLayerMemberAddr)e.getKey()).toString());
            sb.append(" (" + e.getValue() + ")\n");
        }
        return sb.toString();
    }

    @SMConsole(description="Get a list of active alarms and associated classes.")
    public String getAllAlarms() {
        return GenericAlarmHandler.printDetails();
    }

    @SMConsole(description="Get all locations.")
    public Map<Long, Location> getLocations() {
        return ((LocationDAO)debugDM.LOCATION_DAO.get()).getAllLocations();
    }

    @SMConsole(parameterNames={"locationIDs"}, description="Get all locations with the given IDs.")
    public Map<Long, Location> getLocations(Long ... locationIDs) {
        HashMap<Long, Location> locations = new HashMap<Long, Location>();
        for (Long id : locationIDs) {
            locations.put(id, ((LocationDAO)debugDM.LOCATION_DAO.get()).getLocation(id));
        }
        return locations;
    }

    @SMConsole(parameterNames={"name"}, description="Get the location with the given name.")
    public Location getLocationByName(String name) {
        return ((LocationDAO)debugDM.LOCATION_DAO.get()).getLocationByName(name);
    }

    @SMConsole(description="Get all SIP Entities.")
    public Map<Long, SIPEntity> getSIPEntities() {
        return ((SIPEntityDAO)debugDM.SIP_ENTITY_DAO.get()).getAllSIPEntities();
    }

    @SMConsole(parameterNames={"entityIDs"}, description="Get all SIP Entities with the given IDs.")
    public Map<Long, SIPEntity> getSIPEntities(Long ... entityIDs) {
        HashMap<Long, SIPEntity> entities = new HashMap<Long, SIPEntity>();
        for (Long id : entityIDs) {
            entities.put(id, ((SIPEntityDAO)debugDM.SIP_ENTITY_DAO.get()).getSIPEntity(id));
        }
        return entities;
    }

    @SMConsole(parameterNames={"ipAddress"}, description="Get the SIP Entities with the given IP address.")
    public Collection<SIPEntity> getSIPEntitiesByIpAddress(String ipAddress) {
        return ((SIPEntityDAO)debugDM.SIP_ENTITY_DAO.get()).getSIPEntityByAddress(ipAddress);
    }

    @SMConsole
    public List<SMConsoleCommand> setApplication() {
        this.log.info((Object)"Setting command context in SMConsole to ALL");
        return SMConsoleListener.getInstance().loadAllMethods();
    }

    @SMConsole(parameterNames={"name"}, description="Get the SIP Entity with the given name. This method is inefficient; it does an iterative search.")
    public String getSIPEntityByName(String name) {
        for (SIPEntity entity : this.getSIPEntities().values()) {
            if (!entity.getName().equals(name)) continue;
            return entity.toString();
        }
        return "NOT FOUND";
    }

    @SMConsole(description="Get the names of all jgroups that this DDLMember is a part of.")
    public String getClusterNames() {
        return "Intra: " + this.getDDLFactory().getIntraClusterName() + ", Inter: " + this.getDDLFactory().getInterClusterName();
    }

    @SMConsole(parameterNames={"alarmKey"}, description="Cause an alarm resolution event for the given alarm.")
    public DataMgr.Status setAlarmCleared(String alarmKey) {
        if (GenericAlarmHandler.manuallyClearEvent(alarmKey)) {
            return DataMgr.Status.OKAY;
        }
        return DataMgr.Status.FAIL;
    }

    @SMConsole(parameterNames={"dataMgrName"}, description="Get a list of DMListeners that listen for updates to the given DataMgr")
    public List<String> getDMListeners(String dataMgrName) {
        ArrayList<String> listeners = new ArrayList<String>();
        Set<Class<? extends DataMgr>> classes = DebugDM.getDMFactory().getAllDataMgrs().keySet();
        for (Class<? extends DataMgr> clazz : classes) {
            if (!clazz.getSimpleName().equals(dataMgrName)) continue;
            for (DMListener listener : DebugDM.getDMFactory().getDataMgr(clazz).getListeners()) {
                listeners.add(listener.getClass().getSimpleName());
            }
            return listeners;
        }
        listeners.add(dataMgrName + " not currently instantiated - check the parameter (case-sensitive!)");
        return listeners;
    }

    @SMConsole(description="Return the IP address of the System Manager managing this Session Manager.  Accounts for SMGR GeoRedundancy.")
    public String getSystemManagerIP() {
        String myIp = DDLUtilities.getManagementIP();
        String cmd = "curl --connect-timeout 1 -k -silent https://" + myIp + ":8643/asmarbiter/arbiter/V1/getMasterSystemManager";
        String masterSmgr = "Master SMGR:";
        String output = null;
        try {
            String line;
            Process p = Runtime.getRuntime().exec(cmd);
            p.waitFor();
            BufferedReader buf = new BufferedReader(new InputStreamReader(p.getInputStream(), "UTF-8"));
            while ((line = buf.readLine()) != null) {
                if (!line.contains(masterSmgr)) continue;
                output = line.substring(masterSmgr.length());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (output != null) {
            output = (output = output.trim()).contains("None") ? "Geo-Redundancy disabled.  SMGR: " + DMUtilities.getSMGRIpAddr() : "Geo-Redundancy enabled.  Active SMGR: " + output;
        } else if (myIp != null) {
            output = "Web request to determine active SMGR failed.  Installation used " + DMUtilities.getSMGRIpAddr();
        }
        return output;
    }

    @SMConsole(description="Return whether this Session Manager is actively denying new SIP requests. This should normally be false. Returns null if unable to connect to the Maintenance Agent.")
    public Boolean getDenyNewService() {
        DataDistLayerMessage message = new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.MTCAGENT, 3, null);
        for (DataDistLayerMemberAddr member : this.getMember().getMembers()) {
            if (!"Management".equals(member.getMemberType())) continue;
            return (Boolean)this.getMember().queryHost(member, message);
        }
        return null;
    }

    @SMConsole(parameterNames={"deny"}, description="Set whether this Session Manager is actively denying new SIP requests. This should normally be false.")
    public DataMgr.Status setDenyNewService(boolean deny) {
        DataDistLayerMessage message = new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.MTCAGENT, 4, Boolean.valueOf(deny));
        for (DataDistLayerMemberAddr member : this.getMember().getMembers()) {
            if (!"Management".equals(member.getMemberType())) continue;
            Boolean retVal = (Boolean)this.getMember().queryHost(member, message);
            if (retVal == null || !retVal.booleanValue()) break;
            return DataMgr.Status.OKAY;
        }
        return DataMgr.Status.FAIL;
    }

    @SMConsole(description="Send a replication event.  I=insert, U=update, D=delete on the specified table and key", parameterNames={"Type:I:U:D", "TableName", "PrimKey", "SequenceNum"})
    public void repEvent(String type, String tableName, String primKey, Integer seqNum) {
        DAOReplicationEvent event = new DAOReplicationEvent();
        DAOReplicationEvent.OperationType operation = type.equalsIgnoreCase("U") ? DAOReplicationEvent.OperationType.UPDATE : (type.equalsIgnoreCase("I") ? DAOReplicationEvent.OperationType.INSERT : DAOReplicationEvent.OperationType.DELETE);
        event.setOperation(operation);
        event.setPrimaryTable(tableName);
        event.setPrimaryKey(primKey);
        if (seqNum == null) {
            seqNum = 1;
        }
        DAOReplicationEventList repList = new DAOReplicationEventList(seqNum);
        repList.add(event);
        this.getMember().multicastMessage(new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.REPLICATION, 2, repList), false);
    }

    @SMConsole(description="Start the replication initial load.  This first pauses replication servicing, reinitializes all the DAO classes, then resumes replication processing.  The duration specifies how long to sleep between the 'beginning' and the 'completion' of the initial load.  NOTE that this message is sent to all listening parties, not just to the connected member (ie. sent to WAS-SM, CPAgent, etc).  This will also break the sequence numbering between management and any connected members.  This should be realitively harmless and only cause the DAO's to reinit on the next replication event from mgmt.", parameterNames={"duration"})
    public String repInitialLoad(long duration) {
        this.getMember().multicastMessage(new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.REPLICATION, 0, new DAOReplicationEventList(1)), false);
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.getMember().multicastMessage(new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.REPLICATION, 1, new DAOReplicationEventList(2)), false);
        return DebugDM.getDMFactory().getAllDAOClasses().size() + " classes reloaded on connected member.";
    }

    @SMConsole(description="Get some system property")
    public String getProperty(String key) {
        return System.getProperty(key);
    }

    @SMConsole(description="Retrieve JVM memory statistics")
    public String getMemoryStats() {
        Runtime runTime = Runtime.getRuntime();
        long total = runTime.totalMemory();
        long max = runTime.maxMemory();
        long free = runTime.freeMemory();
        long used = total - free;
        long avail = max - total + free;
        String memstat = "Total: " + total + "\n  Max: " + max + "\n Free: " + free + "\n Used: " + used + "\nAvail: " + avail;
        return memstat;
    }

    @SMConsole(parameterNames={"classname | shortname"}, description="Retrieve DAO memory usage. This operation is potentially expensive in both CPU and Memory and should not be executed in rapid succession.")
    public String getDAOMemory(String daoName) {
        try {
            Class<DataMgr> clazz = SMConsoleListener.getInstance().getShortNameClass(daoName);
            if (clazz == null) {
                Class<?> anyClazz;
                if (!daoName.contains(".")) {
                    daoName = DataAccessObject.class.getPackage().getName() + "." + daoName;
                }
                if (DataAccessObject.class.isAssignableFrom(anyClazz = Class.forName(daoName))) {
                    clazz = anyClazz;
                }
            }
            if (DataAccessObject.class.isAssignableFrom(clazz)) {
                Set<Class<? extends DataAccessObject>> loaded_daos = DebugDM.getDMFactory().getAllDAOClasses();
                if (!loaded_daos.contains(clazz)) {
                    return daoName + ": class not loaded";
                }
                return this.getDAOMemoryForClass(clazz);
            }
        }
        catch (ClassNotFoundException e) {
            return daoName + ": class not found";
        }
        catch (Exception e) {
            return "caught unexpected exception: " + e;
        }
        return daoName + ": non-DAO class";
    }

    @SMConsole(description="Retrieve memory usage for all DAOs. This operation is potentially expensive in both CPU and Memory. Avoid scripting recurrent calls to this method.")
    public String getAllDAOMemory() throws ClassNotFoundException {
        Set<Class<? extends DataAccessObject>> daos = DebugDM.getDMFactory().getAllDAOClasses();
        TreeSet<Class<? extends DataAccessObject>> sdaos = new TreeSet<Class<? extends DataAccessObject>>(new ClassNameSorter());
        StringBuffer daomem = new StringBuffer();
        Long total_mem = 0L;
        for (Class<? extends DataAccessObject> clazz : daos) {
            sdaos.add(clazz);
        }
        for (Class<? extends DataAccessObject> clazz : sdaos) {
            String dmem = this.getDAOMemoryForClass(clazz);
            daomem.append(dmem + "\n");
            String sizeStr = dmem.substring(dmem.indexOf(61) + 1);
            sizeStr = sizeStr.substring(0, sizeStr.indexOf(32));
            total_mem = total_mem + Long.parseLong(sizeStr);
        }
        daomem.append("TOTAL=" + total_mem);
        return daomem.toString();
    }

    protected String getDAOMemoryForClass(Class<? extends DataAccessObject> clazz) throws ClassNotFoundException {
        String daoName = clazz.getSimpleName();
        DataAccessObject dm = (DataAccessObject)DebugDM.getDMFactory().getDataMgr(clazz);
        MemoryCounter mCounter = new MemoryCounter();
        long total_dao_mem = 0L;
        StringBuffer dmem = new StringBuffer();
        while (clazz != null && clazz != DataAccessObject.class) {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Class<?> type;
                Field field = fields[i];
                if (Modifier.isStatic(field.getModifiers()) || !Map.class.isAssignableFrom(type = field.getType()) && !Collection.class.isAssignableFrom(type)) continue;
                field.setAccessible(true);
                String name = field.getName();
                try {
                    Object mapToSize = field.get(dm);
                    long mem = 0L;
                    if (mapToSize != null) {
                        mem = mCounter.estimate(mapToSize);
                    }
                    total_dao_mem += mem;
                    if (dmem.length() > 0) {
                        dmem.append(" ");
                    }
                    dmem.append(name + "=" + mem);
                    continue;
                }
                catch (IllegalAccessException ex) {
                    dmem.append(name + ": IllegalAccessException caught during estimate() call ");
                }
            }
            clazz = clazz.getSuperclass();
        }
        return daoName + "=" + total_dao_mem + " [" + dmem + "]";
    }

    public boolean processLocalSetting(String settingName, String value) throws IllegalArgumentException {
        if ("DATABASE_TIMEOUT".equals(settingName)) {
            AsmSettings.setDatabaseTimeout(Integer.parseInt(value));
        } else if ("DATABASE_RETRIES".equals(settingName)) {
            AsmSettings.setDatabaseRetries(Integer.parseInt(value));
        } else if ("INTER_CLUSTER_AUDIT_INTERVAL".equals(settingName)) {
            DDLInterClusterMember interMember = DataDistLayerFactory.getInstance().getInterClusterMember();
            if (interMember != null) {
                interMember.restartFragmentationAudit(10L);
            }
        } else if ("DENY_SERVICE".equals(settingName)) {
            this.setDenyNewService(Boolean.parseBoolean(value));
        } else {
            return false;
        }
        return true;
    }

    @SMConsole(parameterNames={"settingName", "value"}, description="Set a local setting for this Session Manager. These settings are specific to this Session Manager and persist. They can only be changed with the SMConsole. Possible values can be seen with the \"GET AllLocalSettings\" command.")
    public String setLocalSetting(String settingName, String value) {
        return this.setLocalSetting(settingName, value, false);
    }

    @SMConsole(parameterNames={"settingName", "value", "sendToAll"}, description="Set a local setting for this Session Manager. These settings are specific to this Session Manager and persist. They can only be changed with the SMConsole. Possible values can be seen with the \"GET AllLocalSettings\" command.  If the sendToAll is 'true', the same command will be pushed to all other SMs.")
    public String setLocalSetting(String settingName, String value, boolean sendToAll) {
        value = value.trim();
        String foundSetting = null;
        String retStr = null;
        try {
            if ("default".equalsIgnoreCase(value) && (value = LocalSettings.getDefaultValue(settingName)) == null) {
                return "ERROR: no default value available for: " + settingName + "\n";
            }
            foundSetting = LocalSettings.verifyLimits(settingName, value);
            if (foundSetting != null) {
                try {
                    LocalSettings.setDBValue(foundSetting, value);
                    if (this.log.isFinestEnabled()) {
                        this.log.finest((Object)("Set " + foundSetting + " to " + value));
                    }
                    this.processLocalSetting(settingName, value);
                }
                catch (Exception e) {
                    this.log.warn((Object)("Error setting " + settingName + " value to " + value + " in database"));
                    return "ERROR: unable to write entry in database:\n" + DMUtilities.getStackTrace(e);
                }
            } else {
                return "Setting Not Found: '" + settingName + "'";
            }
            retStr = this.getLocalSetting(settingName);
            if (sendToAll) {
                retStr = retStr + "\nSent setting to: " + this.sendToAllOtherClusterNodes(1, (Serializable)((Object)(settingName + DISTR_SETTING_DELIM + value)));
            }
        }
        catch (NumberFormatException e) {
            retStr = "ERROR: Could not set " + settingName + " to '" + value + "' - Bad numerical value";
            this.log.warn((Object)("setLocalSetting: " + retStr), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            retStr = "ERROR: Could not set " + settingName + " to '" + value + "' - " + e.getMessage();
            this.log.warn((Object)("setLocalSetting: " + retStr), (Throwable)e);
        }
        catch (Exception e) {
            this.log.error((Object)("setLocalSetting: Could not set " + settingName + " to " + value), (Throwable)e);
            retStr = "ERROR: Could not set " + settingName + " to " + value;
        }
        return retStr;
    }

    @SMConsole(parameterNames={"settingName"}, description="Get a specific local settings for this Session Manager. These settings are specific to this Session Manager and persist. They can only be changed with the SMConsole. Possible values can be seen with the \"GET AllLocalSettings\" command.")
    public String getLocalSetting(String settingName) {
        List<Field> localParameters = LocalSettings.getLoadedSettings();
        for (Field field : localParameters) {
            if (!field.getName().equalsIgnoreCase(settingName)) continue;
            StringBuffer output = new StringBuffer(field.getName() + "\n - Current Value: " + LocalSettings.getLocalParameter(field.getName()) + "\n");
            Limits limits = field.getAnnotation(Limits.class);
            Description description = field.getAnnotation(Description.class);
            if (limits != null) {
                output.append(" - Default Value: " + LocalSettings.getDefaultValue(limits) + (limits.scaleToProfile() ? " (Scaled to Profile)" : "") + "\n");
                if (limits.minimum() != Long.MIN_VALUE) {
                    output.append(" - Minimum Value: " + limits.minimum() + "\n");
                }
                if (limits.maximum() != Long.MAX_VALUE) {
                    output.append(" - Maximum Value: " + limits.maximum() + "\n");
                }
            }
            if (description == null) {
                output.append("\tNo description provided\n");
            } else {
                output.append("\t" + description.value() + "\n");
            }
            return output.toString();
        }
        return "Setting Not Found";
    }

    @SMConsole(description="Print a list of DDLListener mappings and ClassLoaders.")
    public String getDDLListenerLists() {
        StringBuffer retval = new StringBuffer("IntraCluster:\n");
        this.printListeners(this.getMember().getListenerMap(), retval);
        DDLInterClusterMember interMember = this.getDDLFactory().getInterClusterMember();
        if (interMember != null) {
            retval.append("\nInterCluster:\n");
            this.printListeners(interMember.getListenerMap(), retval);
        }
        retval.append("\n\tApplication ClassLoader Map:\n");
        for (ClassLoader cl : JGroupEncoderDecoder.getApplicationClassLoaders()) {
            retval.append("\t\t" + DMUtilities.getSimpleClassLoaderName(cl) + "\n");
        }
        return retval.toString();
    }

    private void printListeners(Map<DataDistLayerMessage.TargetAppId, DataDistLayerListener> listeners, StringBuffer retval) {
        for (Map.Entry<DataDistLayerMessage.TargetAppId, DataDistLayerListener> entry : listeners.entrySet()) {
            retval.append("\t" + (Object)((Object)entry.getKey()) + " - " + entry.getValue().getClass().getSimpleName() + " : " + DMUtilities.getSimpleClassLoaderName(entry.getValue().getClass().getClassLoader()) + "\n");
        }
    }

    @SMConsole(description="Get a list of all local settings for this Session Manager. These settings are specific to this Session Manager and persist. They can only be changed with the SMConsole.")
    public String getAllLocalSettings() {
        StringBuffer output = new StringBuffer();
        List<Field> localParameters = LocalSettings.getLoadedSettings();
        for (Field field : localParameters) {
            output.append(field.getName() + ": " + LocalSettings.getLocalParameter(field.getName()) + "\n");
        }
        return output.toString();
    }

    public String sendToAllOtherClusterNodes(int msgType, Serializable payload) {
        DDLInterClusterMember interMember = DataDistLayerFactory.getInstance().getInterClusterMember();
        StringBuffer affectedMembers = new StringBuffer("Just us.");
        if (interMember != null) {
            List<DataDistLayerMemberAddr> affected = interMember.getMembers();
            interMember.multicastMessage(new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.DEBUGGING, msgType, payload));
            affectedMembers = new StringBuffer();
            for (DataDistLayerMemberAddr addr : affected) {
                affectedMembers.append("\n" + addr.getHostId() + ", " + AsmCommon.versionToString(addr.getMemberVersion()));
            }
        }
        return affectedMembers.toString();
    }

    @SMConsole(description="Return whether a DRS Initial Load is in progress")
    public boolean getInitialLoadInProgress() {
        return DAOReplicationListener.initialLoadInProgress();
    }

    @SMConsole(description="Dump the load rules currently stored in DMFactory")
    public String getAllLoadRules() {
        return DMFactory.getInstance().getLoadRules().toString();
    }

    @SMConsole(description="Dump the maps in the DMFactory")
    public String getAllFactoryMaps() {
        return DebugDM.getDMFactory().dumpFactoryMaps();
    }

    @SMConsole(description="Dump data about the DDL and JGroups queues. WARNING that if showContents is true, this may generate a lot of garbage if the queues are backed up", parameterNames={"showContents"})
    public String dumpJGroupsQueues(boolean showContents) {
        DataDistLayerMember mbr = this.getDDLFactory().getIntraClusterMember();
        StringBuilder sb = new StringBuilder();
        if (mbr != null) {
            sb.append((CharSequence)mbr.dumpJGroupsQueues(showContents));
        }
        if ((mbr = this.getDDLFactory().getInterClusterMember()) != null) {
            sb.append("**************************************************\n" + mbr.dumpJGroupsQueues(showContents));
        }
        if (sb.length() == 0) {
            sb.append("No members");
        }
        return sb.toString();
    }

    @SMConsole(description="Perform GC")
    public String getGarbageCollection() {
        this.log.info((Object)"DebugDM: Manually performing GC.");
        System.gc();
        return "Done";
    }

    @SMConsole(description="Perform JGroups fragmentation audit")
    public boolean getStartFragmentationAudit() {
        DDLInterClusterMember interMember = DataDistLayerFactory.getInstance().getInterClusterMember();
        if (interMember != null) {
            interMember.startFragmentationAudit();
        }
        return true;
    }

    public Map<Class<? extends DataMgr>, String> getClassShortNames() {
        HashMap<Class<? extends DataMgr>, String> loadedClasses = new HashMap<Class<? extends DataMgr>, String>();
        loadedClasses.put(AppSetDAO.class, "APPSET");
        loadedClasses.put(AppSetPatternDAO.class, "APPSETPAT");
        loadedClasses.put(AsmCommProfileDAO.class, "ASMPROF");
        loadedClasses.put(AsmInstanceDAO.class, "ASM");
        loadedClasses.put(AusCommProfileDAO.class, "AUSPROF");
        loadedClasses.put(CPDeviceSettingsDAO.class, "CPDEV");
        loadedClasses.put(CmCommProfileDAO.class, "CMPROF");
        loadedClasses.put(DigitMapRouterDAO.class, "DMR");
        loadedClasses.put(EntityLinkTableDAO.class, "ELT");
        loadedClasses.put(EventDAO.class, "EVNT");
        loadedClasses.put(HostNameDAO.class, "HOSTNM");
        loadedClasses.put(LocationDAO.class, "LOC");
        loadedClasses.put(LocationPatternDAO.class, "LOCPAT");
        loadedClasses.put(NameResolutionDM.class, "NR");
        loadedClasses.put(PerformanceMonitoringDDM.class, "PMON");
        loadedClasses.put(PsCommProfileDAO.class, "PSPROF");
        loadedClasses.put(RoutePolicyDAO.class, "RP");
        loadedClasses.put(SetCommunityDAO.class, "SETCOM");
        loadedClasses.put(SetSurvivableDAO.class, "SETSRV");
        loadedClasses.put(SIPDomainDAO.class, "SIPDMN");
        loadedClasses.put(SIPEntityDAO.class, "SIPENT");
        loadedClasses.put(TimeDAO.class, "TIME");
        loadedClasses.put(UserCommunityDAO.class, "USRCOM");
        loadedClasses.put(CsDomainDAO.class, "CSDMN");
        loadedClasses.put(CsHandleDAO.class, "HANDLE");
        loadedClasses.put(GlobalDAO.class, "GLOB");
        loadedClasses.put(DebugDM.class, "ALL");
        loadedClasses.put(new DataMgr(){

            @Override
            public void init() {
            }
        }.getClass(), "NON_DM");
        return loadedClasses;
    }

    @Override
    public DataDistLayerMessage.TargetAppId getListenerAppId() {
        return DataDistLayerMessage.TargetAppId.DEBUGGING;
    }

    @Override
    public void hostLeftTheGroup(DataDistLayerMemberAddr hostId, GroupCommIntf.DDLGroupType groupType) {
    }

    @Override
    public void thisMemberJoinedTheGroup(DataDistLayerMemberAddr thisMemberId, GroupCommIntf.DDLGroupType ddlGroupType) {
    }

    @Override
    public void otherMemberJoined(DataDistLayerMemberAddr otherMemberId, GroupCommIntf.DDLGroupType ddlGroupType) {
    }

    @Override
    public void dataStored(DataDistLayerMemberAddr senderId, DataDistLayerData data) {
    }

    @Override
    public void dataUpdated(DataDistLayerMemberAddr senderId, DataDistLayerData priorData, DataDistLayerData updatedData) {
    }

    @Override
    public void dataRemoved(DataDistLayerMemberAddr senderId, DataDistLayerData removedData) {
    }

    @Override
    public void bulkStoreReceived(DataDistLayerMemberAddr senderId, List<DataDistLayerData> dataList) {
    }

    @Override
    public void bulkRemoveReceived(DataDistLayerMemberAddr senderId, List<DataDistLayerData> dataList) {
    }

    @Override
    public void processMessage(DataDistLayerMessage message, DataDistLayerMemberAddr senderId) {
        switch (message.getMessageType()) {
            case 1: {
                String payload = (String)((Object)message.getPayload());
                int idx = payload.indexOf(DISTR_SETTING_DELIM);
                this.setLocalSetting(payload.substring(0, idx), payload.substring(idx + DISTR_SETTING_DELIM.length()), false);
                return;
            }
        }
        for (DebugDMAppBase listener : this.listeners) {
            if (null == listener || !listener.processMessage(message, senderId)) continue;
            return;
        }
    }

    @Override
    public Object handleMessage(DataDistLayerMessage message, DataDistLayerMemberAddr srcMember) {
        Object retObj = null;
        for (DebugDMAppBase listener : this.listeners) {
            if (null == listener || null == (retObj = listener.handleMessage(message, srcMember))) continue;
            return retObj;
        }
        return null;
    }

    protected void addListener(DebugDMAppBase listener) {
        this.listeners.add(listener);
    }

    protected class ClassNameSorter
    implements Comparator<Class<? extends DataAccessObject>> {
        protected ClassNameSorter() {
        }

        @Override
        public int compare(Class<? extends DataAccessObject> clazz1, Class<? extends DataAccessObject> clazz2) {
            return clazz1.getSimpleName().compareTo(clazz2.getSimpleName());
        }
    }

    public static enum debugDM implements BLDMEnumType
    {
        LOCATION_DAO(LocationDAO.class),
        SIP_ENTITY_DAO(SIPEntityDAO.class);

        private Class<? extends DataMgr> subDM;

        private debugDM(Class<? extends DataMgr> dm) {
            this.subDM = dm;
        }

        @Override
        public DataMgr get() {
            return DebugDM.getDMFactory().getDataMgr(this.subDM);
        }
    }
}

