/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.ResolvedLocation;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.datamgr.BLDMEnumType;
import com.avaya.asm.datamgr.BusinessLogicDM;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.HostNameDAO;
import com.avaya.asm.datamgr.dao.SIPEntityDAO;
import com.avaya.asm.datamgr.objectapi.FQDNOrIpAddr;
import com.avaya.asm.datamgr.objectapi.ResolvedIPAddress;
import com.avaya.asm.datamgr.objectapi.ResolvedName;
import com.avaya.asm.datamgr.objectapi.SIPEntity;
import com.avaya.common.logging.client.Logger;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

public class NameResolutionDM
extends BusinessLogicDM {
    private final Logger log = AsmLogger.getLogger(NameResolutionDM.class);
    protected static DMFactory factory;

    public static DMFactory getFactory() {
        if (factory == null) {
            factory = DMFactory.getInstance();
        }
        return factory;
    }

    @Override
    public EnumSet<? extends BLDMEnumType> getDMUsages() {
        return EnumSet.allOf(nreDM.class);
    }

    @Override
    public void init() {
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Initializing " + this.getClass().getSimpleName()));
        }
        DataMgr.Status status = DataMgr.Status.OKAY;
        for (nreDM dm : nreDM.values()) {
            if (dm.get().okay()) continue;
            status = DataMgr.Status.FAIL;
            this.log.error((Object)("Failed to init: " + dm));
        }
        this.setStatus(status);
    }

    @SMConsole(description="Get all provisioned SIPEntity objects.")
    public Map<Long, SIPEntity> getAllSIPEntities() {
        return ((SIPEntityDAO)nreDM.SIP_ENTITY_DAO.get()).getAllSIPEntities();
    }

    public void setSIPEntityAddresses(Long entityId, String fqdn, boolean isFqdn2, List<ResolvedLocation> addressList, boolean useRFC3263, long ttl) {
        ((HostNameDAO)nreDM.HOSTNAME_DAO.get()).setSIPEntityAddresses(entityId, fqdn, isFqdn2, addressList, useRFC3263, ttl);
    }

    @SMConsole(description="Get all NRE entity addresses sorted by TTL.")
    public List<ResolvedName> getSIPEntityAddressesByTTL() {
        return ((HostNameDAO)nreDM.HOSTNAME_DAO.get()).getSIPEntityAddressesByTTL();
    }

    public ResolvedName resolveName(String fqdn) {
        return ((HostNameDAO)nreDM.HOSTNAME_DAO.get()).getResolvedName(fqdn);
    }

    public ResolvedName resolveProvisionedName(String fqdn) {
        return ((HostNameDAO)nreDM.HOSTNAME_DAO.get()).getResolvedNameProvisionedOnly(fqdn);
    }

    public boolean matchHosts(String host1str, String host2str) {
        boolean returnValue = false;
        FQDNOrIpAddr host1 = new FQDNOrIpAddr(host1str);
        FQDNOrIpAddr host2 = new FQDNOrIpAddr(host2str);
        if (host1.isNull() || host2.isNull()) {
            returnValue = host1.isNull() && host2.isNull();
        } else if (host1.equals(host2)) {
            returnValue = true;
        } else if (host1.isIPAddress()) {
            ResolvedName name2;
            if (!host2.isIPAddress() && (name2 = ((HostNameDAO)nreDM.HOSTNAME_DAO.get()).getResolvedName(host2str)) != null) {
                for (ResolvedIPAddress address : name2.getAddresses()) {
                    if (!host1.isEqualTo(address.getIpaddress())) continue;
                    returnValue = true;
                    break;
                }
            }
        } else {
            ResolvedName name1 = ((HostNameDAO)nreDM.HOSTNAME_DAO.get()).getResolvedName(host1str);
            if (host2.isIPAddress()) {
                if (name1 != null) {
                    for (ResolvedIPAddress address : name1.getAddresses()) {
                        if (!host2.isEqualTo(address.getIpaddress())) continue;
                        returnValue = true;
                        break;
                    }
                }
            } else {
                ResolvedName name2 = ((HostNameDAO)nreDM.HOSTNAME_DAO.get()).getResolvedName(host2str);
                if (name1 != null && name2 != null) {
                    for (ResolvedIPAddress address1 : name1.getAddresses()) {
                        FQDNOrIpAddr addr1 = new FQDNOrIpAddr(address1.getIpaddress());
                        for (ResolvedIPAddress address2 : name2.getAddresses()) {
                            if (!addr1.isEqualTo(address2.getIpaddress())) continue;
                            returnValue = true;
                            break;
                        }
                        if (!returnValue) continue;
                        break;
                    }
                }
            }
        }
        if (this.log.isFinestEnabled()) {
            this.log.finest((Object)("matchHosts(" + host1str + "," + host2str + ") returning " + returnValue));
        }
        return returnValue;
    }

    public boolean matchHosts(SIPEntity entity, String host2str) {
        return this.matchHosts(entity.getFqdnoripaddr(), host2str) || this.matchHosts(entity.getFqdnoripaddr2(), host2str);
    }

    protected static enum nreDM implements BLDMEnumType
    {
        HOSTNAME_DAO(HostNameDAO.class),
        SIP_ENTITY_DAO(SIPEntityDAO.class);

        private Class<? extends DataMgr> subDM;

        private nreDM(Class<? extends DataMgr> dm) {
            this.subDM = dm;
        }

        @Override
        public DataMgr get() {
            return NameResolutionDM.getFactory().getDataMgr(this.subDM);
        }
    }
}

