/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.core.SMConsole;
import com.avaya.asm.datamgr.dao.CommProfileDAO;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.objectapi.CmCommProfile;
import com.avaya.asm.datamgr.objectapi.CsCommProfile;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CmCommProfileDAO
extends CommProfileDAO {
    public static final String commProfileType = "CM";
    private static final ResultSetMapper mapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            ConcurrentHashMap<Long, CmCommProfile> profileMap = new ConcurrentHashMap<Long, CmCommProfile>();
            while (rs.next()) {
                long id = rs.getLong("id");
                profileMap.put(id, new CmCommProfile((Long)id, (Long)rs.getObject("cscommprofilesetid"), (Long)rs.getObject("preferredhandleid"), (Long)rs.getObject("station_id")));
            }
            return profileMap;
        }
    };

    @Override
    public String getMainTable() {
        return "cmcommprofile";
    }

    @Override
    protected String getSelectFields() {
        return "SELECT cs.id, cs.cscommprofilesetid, cs.preferredhandleid, cm.station_id FROM cscommprofile cs JOIN cmcommprofile cm ON cs.id=cm.id";
    }

    @Override
    protected ResultSetMapper getMapper() {
        return mapper;
    }

    public CmCommProfile getCmCommProfile(Long id) {
        try {
            this.lock.acquireReadLock();
            if (id != null) {
                CmCommProfile cmCommProfile = (CmCommProfile)this.csCommProfileMap.get(id);
                return cmCommProfile;
            }
            CmCommProfile cmCommProfile = null;
            return cmCommProfile;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmCommProfile getCmCommProfileBySetId(Long setId) {
        try {
            this.lock.acquireReadLock();
            Long id = (Long)this.setIdMap.get(setId);
            if (id != null) {
                CmCommProfile cmCommProfile = (CmCommProfile)this.csCommProfileMap.get(id);
                return cmCommProfile;
            }
            CmCommProfile cmCommProfile = null;
            return cmCommProfile;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get all CmCommProfiles cached in memory.")
    public Map<Long, CsCommProfile> getCmCommProfiles() {
        this.lock.acquireReadLock();
        try {
            Map<Long, CsCommProfile> map = Collections.unmodifiableMap(this.csCommProfileMap);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Override
    protected String getCommProfileType() {
        return commProfileType;
    }

    public static void main(String[] args) {
        CmCommProfileDAO dao = new CmCommProfileDAO();
        dao.printQueries();
    }
}

