/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.branch;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.AppSetDAO;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.AppSetAssign;
import com.avaya.asm.datamgr.objectapi.AppSetMember;
import com.avaya.asm.datamgr.objectapi.AsmApplication;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BranchAppSetDAO
extends AppSetDAO {
    private final Logger log = AsmLogger.getLogger(BranchAppSetDAO.class);
    protected static final String getCMEntities = "SELECT id FROM sipentity WHERE entitytype = 'CM'";
    protected static final ResultSetMapper CMMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, Object> CMs = new HashMap<Long, Object>();
            while (rs.next()) {
                CMs.put(rs.getLong("id"), null);
            }
            return CMs;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void init() {
        Map cmIds;
        Map assignSetMapTMP;
        Map applicationMapTMP;
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Initializing " + BranchAppSetDAO.class.getSimpleName()));
        }
        Map attributeMapTMP = null;
        Object[] params = new Object[]{};
        try {
            attributeMapTMP = (Map)this.dataSource.executeQuery("SELECT id, asmapplication_id, attributename, attributevalue FROM asmapplicationattribute", params, this.attributesMapper);
            applicationMapTMP = (Map)this.dataSource.executeQuery("SELECT id, sipentity_id, do_media_filtering, accepts_audio, accepts_video, accepts_text, match_type, if_no_sdp FROM asmapplication", params, applicationsMapper);
            assignSetMapTMP = (Map)this.dataSource.executeQuery("SELECT id, application_id, appset_id, orderofexecution, ismandatory, isprimaryfs FROM asmappsetassign", params, assignmentsMapper);
            cmIds = (Map)this.dataSource.executeQuery(getCMEntities, params, CMMapper);
            for (AppSetDAO.Attribute attribute : attributeMapTMP.values()) {
                if (!applicationMapTMP.containsKey(attribute.appId)) continue;
                ((AsmApplication)applicationMapTMP.get(attribute.appId)).setAttribute(attribute.name, attribute.value);
            }
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        this.lock.acquireWriteLock();
        try {
            if (this.okay()) {
                this.applicationMap = applicationMapTMP;
                this.attributeMap = attributeMapTMP;
                this.assignSetMap = assignSetMapTMP;
                this.setMap = new HashMap();
                this.assignIdMap = new HashMap();
                for (Map.Entry entry : this.assignSetMap.entrySet()) {
                    Long appSetId = (Long)entry.getKey();
                    for (AppSetAssign assign : (List)entry.getValue()) {
                        this.assignIdMap.put(assign.getId(), appSetId);
                    }
                    this.populateAppSet(appSetId, cmIds);
                }
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateAppSet(Long setId, Map<Long, Long> cmIds) {
        this.lock.acquireWriteLock();
        try {
            this.setMap.remove(setId);
            if (setId == null || !this.assignSetMap.containsKey(setId)) {
                return;
            }
            this.setMap.put(setId, new ArrayList());
            Collections.sort((List)this.assignSetMap.get(setId), this.sorter);
            for (AppSetAssign assign : (List)this.assignSetMap.get(setId)) {
                AsmApplication app = (AsmApplication)this.applicationMap.get(assign.getApplicationId());
                if (!cmIds.containsKey(app.getSipEntityId())) continue;
                AppSetMember member = new AppSetMember(app.getMediaAttributes(), assign.getMandatory(), assign.getPrimaryFS(), app.getSipEntityId(), app.getHandle(), app.getURIParams());
                ((List)this.setMap.get(setId)).add(member);
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public void updateDAO(DAOTableEvent event) {
        this.log.fine((Object)"updateDAO: reinitialize");
        this.reinit();
    }

    @Override
    public List<String> getDependentTables() {
        List<String> list = super.getDependentTables();
        list.add("sipentity");
        return list;
    }
}

