/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.branch;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.BSMNoEntityLinksAlarmException;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.AsmInstanceDAO;
import com.avaya.asm.datamgr.dao.FeatureServerDAO;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.AsmInstance;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class BranchFeatureServerDAO
extends FeatureServerDAO {
    private final Logger log = AsmLogger.getLogger(BranchFeatureServerDAO.class);
    protected AtomicLong featureServerId = null;
    protected static final String getFeatureServers = "SELECT DISTINCT app.sipentity_id FROM asmapplication app JOIN entitylink link ON link.entity2_id = app.sipentity_id WHERE app.ipt_cm_id = ? AND link.entity1_id = ?";
    protected static final ResultSetMapper featureServerMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            if (rs.next()) {
                return rs.getLong("sipentity_id");
            }
            return null;
        }
    };

    public BranchFeatureServerDAO() {
        super(true);
    }

    @Override
    public synchronized void init() {
        Long featureServerIdTMP;
        AsmInstance myInstance;
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Initializing " + BranchFeatureServerDAO.class.getSimpleName()));
        }
        if ((myInstance = ((AsmInstanceDAO)this.getDataMgr(AsmInstanceDAO.class)).getMyAsmInstance()) == null) {
            if (this.log.isFineEnabled()) {
                this.log.fine((Object)"Don't know instance - giving up");
            }
            this.featureServerId = null;
            this.setStatus(DataMgr.Status.OKAY);
            return;
        }
        try {
            Long cmAppId = myInstance.getCmAppId();
            if (cmAppId == null) {
                this.log.error((Object)"Don't know my CM app ID - failed to initialize!");
                throw new DMException("Failed to read CM app ID for branch");
            }
            Long myEntityId = myInstance.getSipEntityId();
            if (myEntityId == null) {
                this.log.error((Object)"Don't know my entity ID - failed to initialize!");
                throw new DMException("Failed to read instance entity for branch");
            }
            Object[] params = new Object[]{cmAppId, myEntityId};
            featureServerIdTMP = (Long)this.dataSource.executeQuery(getFeatureServers, params, featureServerMapper);
            if (this.log.isFineEnabled()) {
                this.log.fine((Object)("Feature server is " + featureServerIdTMP));
            }
            if (featureServerIdTMP == null) {
                BSMNoEntityLinksAlarmException e = new BSMNoEntityLinksAlarmException("No feature server entity assigned to branch users");
                this.handleFailureEvent(e);
            }
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            this.handleFailureEvent(e);
            return;
        }
        this.featureServerId = featureServerIdTMP == null ? null : new AtomicLong(featureServerIdTMP);
    }

    @Override
    public void updateDAO(DAOTableEvent event) {
        this.log.fine((Object)"updateDAO: reinitialize");
        this.reinit();
    }

    @Override
    public void objectChanged(Object oldObject, Object newObject) {
        this.log.fine((Object)("objectChanged(" + oldObject + ", " + newObject + ")"));
        this.reinit();
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("asmapplication");
        list.add("entitylink");
        return list;
    }

    @Override
    protected Object getMainCollection() {
        ArrayList<AtomicLong> serverList = new ArrayList<AtomicLong>();
        serverList.add(this.featureServerId);
        return serverList;
    }

    @SMConsole(description="Get entity ID of the feature server.")
    public Long getFeatureServerId() {
        if (this.featureServerId == null) {
            return null;
        }
        return this.featureServerId.get();
    }

    protected void handleFailureEvent(Exception e) {
        GenericAlarmHandler.handleFailureEvent(this, e);
    }
}

