/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.branch;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.RoutePolicyDAO;
import com.avaya.asm.datamgr.dao.SIPEntityDAO;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.RoutePolicy;
import com.avaya.asm.datamgr.objectapi.SIPEntity;
import com.avaya.common.logging.client.Logger;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class BranchRoutePolicyDAO
extends RoutePolicyDAO {
    private final Logger log = AsmLogger.getLogger(BranchRoutePolicyDAO.class);
    protected static final String queryDigitPoliciesByRPId = "SELECT id, digitmap_id, routingpolicy_id FROM digitmaptopolicy WHERE routingpolicy_id = ?";

    public BranchRoutePolicyDAO() {
        super(true);
    }

    @Override
    public synchronized void init() {
        Map<Long, List<RoutePolicy>> routePolicyListMapTMP;
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Initializing " + BranchRoutePolicyDAO.class.getSimpleName()));
        }
        ConcurrentHashMap<Long, RoutePolicy> routePolicyMapTMP = new ConcurrentHashMap<Long, RoutePolicy>();
        ConcurrentHashMap<Long, RoutePolicyDAO.RouteDigitPair> digitPolicyMapTMP = new ConcurrentHashMap<Long, RoutePolicyDAO.RouteDigitPair>();
        try {
            Map map;
            Object[] params;
            Map<Long, SIPEntity> entityMap = ((SIPEntityDAO)this.getDataMgr(SIPEntityDAO.class)).getAllSIPEntities();
            for (Long id : entityMap.keySet()) {
                params = new Object[]{id};
                map = (Map)this.dataSource.executeQuery("SELECT routingpolicy.id, sipentity_id, timezone_id, disabled, retries FROM routingpolicy LEFT OUTER JOIN sipentity  ON sipentity.id = routingpolicy.sipentity_id WHERE sipentity.id = ?", params, routePolicyMapper);
                routePolicyMapTMP.putAll(map);
            }
            for (Long id : routePolicyMapTMP.keySet()) {
                params = new Object[]{id};
                map = (Map)this.dataSource.executeQuery(queryDigitPoliciesByRPId, params, digitPolicyMapper);
                digitPolicyMapTMP.putAll(map);
            }
            routePolicyListMapTMP = this.buildRoutePolicyListMap(routePolicyMapTMP, digitPolicyMapTMP);
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        if (this.okay()) {
            this.routePolicyMap = routePolicyMapTMP;
            this.routePolicyListMap = routePolicyListMapTMP;
            this.digitPolicyMap = digitPolicyMapTMP;
        }
    }

    public Set<Long> getDigitMapIds() {
        HashSet<Long> digitMapIds = new HashSet<Long>();
        for (RoutePolicyDAO.RouteDigitPair pair : this.digitPolicyMap.values()) {
            digitMapIds.add(pair.getDigitMapId());
        }
        return digitMapIds;
    }

    @Override
    public synchronized void updateDAO(DAOTableEvent event) {
        this.log.fine((Object)"updateDAO: reinitialize");
        this.reinit();
    }

    @Override
    public void objectChanged(Object oldObject, Object newObject) {
        this.log.fine((Object)("objectChanged(" + oldObject + ", " + newObject + ")"));
        this.reinit();
    }

    @Override
    public Object getMainCollection() {
        return this.digitPolicyMap;
    }
}

