/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.jdbc;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.jdbc.DAOResult;
import com.avaya.asm.datamgr.dao.jdbc.DaoConnectionPool;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.common.logging.client.Logger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DaoConnection {
    private static final Logger log = AsmLogger.getLogger(DaoConnection.class);
    protected Connection connection;
    protected DaoConnectionPool pool;

    public DaoConnection(Connection conn, DaoConnectionPool pool) {
        this.connection = conn;
        this.pool = pool;
        log.fine((Object)("DaoConnection constructed with connection: " + this.connection));
    }

    protected PreparedStatement createStatement(String sql, Object[] parameters) throws DMException {
        return this.createStatement(sql, parameters, 0, false);
    }

    protected PreparedStatement createStatement(String sql, Object[] parameters, int size, boolean isRecursiveCall) throws DMException {
        PreparedStatement stmt = null;
        try {
            if (size > 0) {
                stmt = this.connection.prepareStatement(sql, 1003, 1007);
                stmt.setFetchSize(size);
            } else {
                stmt = this.connection.prepareStatement(sql);
            }
        }
        catch (SQLException e) {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (!isRecursiveCall && this.isConnectionError(e)) {
                this.reset();
                stmt = this.createStatement(sql, parameters, size, true);
            }
            log.error((Object)("error creating statement \"" + sql + "\""), (Throwable)e);
            throw new DMException("Unable to create statement \"" + sql + "\"", e);
        }
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                try {
                    if (parameters[i] == null) {
                        stmt.setNull(i + 1, 1111);
                        continue;
                    }
                    stmt.setObject(i + 1, parameters[i]);
                    continue;
                }
                catch (SQLException e) {
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    throw new DMException("Unable to set parameter " + i + " in \"" + stmt + "\"", e);
                }
            }
        }
        return stmt;
    }

    public Object query(String queryName, Object[] values, ResultSetMapper mapper) throws DMException {
        return this.query(queryName, values, mapper, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object query(String querySQL, Object[] values, ResultSetMapper mapper, int fetchSize) throws DMException {
        PreparedStatement stmt = this.createStatement(querySQL, values, fetchSize, false);
        if (stmt == null) {
            throw new DMException("Invalid statement: " + querySQL);
        }
        if (log.isFinerEnabled()) {
            log.finer((Object)("query: " + stmt));
        }
        try {
            try {
                ResultSet rs = stmt.executeQuery();
                Object object = mapper.mapResults(rs);
                return object;
            }
            catch (SQLException ex) {
                if (!this.isConnectionError(ex)) throw ex;
                this.reset();
                if (log.isFineEnabled()) {
                    log.fine((Object)("Retrying query due to DB connection error: " + querySQL));
                }
                stmt.close();
                stmt = this.createStatement(querySQL, values, fetchSize, false);
                ResultSet rs = stmt.executeQuery();
                Object object2 = mapper.mapResults(rs);
                return object2;
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException ex2) {
            this.pool.reset();
            this.reset();
            throw new DMException("error executing query", ex2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DAOResult executeUpdate(String sql, Object[] params) throws DMException {
        PreparedStatement stmt = this.createStatement(sql, params);
        if (stmt == null) {
            throw new DMException("Invalid statement: " + sql);
        }
        if (log.isFinerEnabled()) {
            log.finer((Object)("executeUpdate:  '" + sql + "'"));
        }
        try {
            try {
                DAOResult res = new DAOResult(stmt.executeUpdate());
                if (log.isFinerEnabled()) {
                    log.finer((Object)(res.getCount() + " row(s) updated"));
                }
                DAOResult dAOResult = res;
                return dAOResult;
            }
            catch (SQLException ex) {
                if (!this.isConnectionError(ex)) throw ex;
                this.reset();
                stmt = this.createStatement(sql, params);
                if (log.isFineEnabled()) {
                    log.fine((Object)("Retrying update due to DB connection error: " + sql));
                }
                DAOResult dAOResult2 = new DAOResult(stmt.executeUpdate());
                return dAOResult2;
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException ex2) {
            this.pool.reset();
            this.reset();
            throw new DMException("error executing query", ex2);
        }
    }

    public void close() throws DMException {
        this.pool.releaseConnection(this);
    }

    public Connection getJdbcConnection() {
        return this.connection;
    }

    public boolean reset() {
        log.info((Object)"Resetting database connection");
        try {
            this.connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.connection = this.pool.getJdbcConnection();
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    boolean isConnectionError(SQLException ex) {
        boolean bval;
        String sqlstate = ex.getSQLState();
        if (sqlstate == null) {
            return false;
        }
        boolean bl = bval = sqlstate.startsWith("08") || sqlstate.startsWith("57P");
        if (log.isFinerEnabled()) {
            log.warn((Object)("SQLException caught, was " + (bval ? "caused" : "not caused") + " by a connection problem: " + sqlstate));
        }
        return bval;
    }
}

