/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.datadistributionlayer;

import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class BlockingWaitNotifyQueue<E> {
    private BlockingQueue<E> eventQueue = new LinkedBlockingQueue();
    private boolean canRun = true;

    public synchronized E poll() throws InterruptedException {
        while (this.eventQueue.isEmpty() && this.canRun) {
            this.wait();
        }
        return this.eventQueue.poll();
    }

    public synchronized void add(E event) {
        if (event != null) {
            this.eventQueue.add(event);
        }
        this.notify();
    }

    public int size() {
        return this.eventQueue.size();
    }

    public synchronized void purgeQueue(E e, Comparator<E> comp) {
        Iterator iterator = this.eventQueue.iterator();
        while (iterator.hasNext()) {
            Object currentEntry = iterator.next();
            if (comp.compare(e, currentEntry) != 0) continue;
            iterator.remove();
        }
    }

    public synchronized void stop() {
        this.canRun = false;
        this.notify();
    }

    public Iterator<E> iterator() {
        return this.eventQueue.iterator();
    }
}

