/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.datadistributionlayer;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMember;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMemberAddr;
import com.avaya.common.logging.client.Logger;
import java.util.List;
import java.util.TimerTask;

public class DDLMemberDelayedTypeChecker
extends TimerTask {
    private DataDistLayerMemberAddr member;
    private DataDistLayerMember callback;
    private boolean isResolved = false;
    private int numTries = 0;
    private static final Logger log = AsmLogger.getLogger(DDLMemberDelayedTypeChecker.class);

    public DDLMemberDelayedTypeChecker(DataDistLayerMemberAddr member, DataDistLayerMember callback) {
        this.member = member;
        this.callback = callback;
    }

    @Override
    public void run() {
        block8: {
            Thread.currentThread().setName("DDLMemberDelayedTypeCheckerThread");
            List<DataDistLayerMemberAddr> members = this.callback.getMembers();
            if (!this.isResolved && members.contains(this.member)) {
                try {
                    if (members.get(members.indexOf(this.member)) != this.member) {
                        log.warn((Object)"run: reference to member changed, using updated one.");
                    }
                    this.member = members.get(members.indexOf(this.member));
                    if (this.member.getMemberType() == null) {
                        log.info((Object)("The member that recently joined is still unresolved.  We are going to assume a network hiccup and proactively request its type information.  So far we have tried " + this.numTries + " times for " + this.member));
                        if (++this.numTries > 20) {
                            log.error((Object)("run: We tried for a very long time to get this member's information.  Assuming an error case for " + this.member));
                            this.cancel();
                        }
                        this.callback.sendMyType(this.member);
                        break block8;
                    }
                    this.isResolved = true;
                    if (log.isFinestEnabled()) {
                        log.finest((Object)"The member that recently joined is now resolved.");
                    }
                    this.cancel();
                }
                catch (Exception e) {
                    log.fine((Object)"Exception occurred while waiting to receive new member's type.", (Throwable)e);
                }
            } else {
                this.cancel();
            }
        }
    }
}

