/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.datadistributionlayer;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.AsmSettings;
import com.avaya.asm.core.LocalSettings;
import com.avaya.asm.datamgr.datadistributionlayer.DDLException;
import com.avaya.asm.datamgr.datadistributionlayer.DDLMemberDelayedTypeChecker;
import com.avaya.asm.datamgr.datadistributionlayer.DDLUtilities;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerFactory;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerInterface;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerListener;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMemberAddr;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMessage;
import com.avaya.asm.datamgr.datadistributionlayer.GroupCommIntf;
import com.avaya.asm.datamgr.datadistributionlayer.GroupCommListener;
import com.avaya.asm.datamgr.datadistributionlayer.JGroupEncoderDecoder;
import com.avaya.common.logging.client.Logger;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class DataDistLayerMember
implements DataDistLayerInterface,
GroupCommListener {
    private static final Logger log = AsmLogger.getLogger(DataDistLayerMember.class);
    protected GroupCommIntf myClusterGroup;
    protected String myClusterName;
    protected List<DataDistLayerMemberAddr> myClusterMembers = new CopyOnWriteArrayList<DataDistLayerMemberAddr>();
    protected Map<Object, DataDistLayerMemberAddr> memberMapping = new ConcurrentHashMap<Object, DataDistLayerMemberAddr>();
    protected Object myClusterLeaderId;
    protected DataDistLayerFactory ddlFactory;
    protected GroupCommIntf.DDLGroupType myGroupType;
    protected String myMemberType;
    protected Map<DataDistLayerMessage.TargetAppId, WeakReference<DataDistLayerListener>> listenerMap = new ConcurrentHashMap<DataDistLayerMessage.TargetAppId, WeakReference<DataDistLayerListener>>();
    protected Timer getTypeExecutor = new Timer();
    private volatile DataDistLayerMemberAddr myAddr = null;

    protected DataDistLayerMember() {
    }

    protected DataDistLayerMember(String clusterName, String myMemberType, DataDistLayerFactory ddlFactory) {
        this.myClusterName = clusterName;
        this.myMemberType = myMemberType;
        this.ddlFactory = ddlFactory;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected double getDDLVersion() {
        return DDLUtilities.getDDLVersion(this);
    }

    public void setMyClusterName(String myClusterName) {
        this.myClusterName = myClusterName;
    }

    @Override
    public void addListener(DataDistLayerListener listener) {
        this.listenerMap.put(listener.getListenerAppId(), new WeakReference<DataDistLayerListener>(listener));
        JGroupEncoderDecoder.mergeClassLoaders(listener.getClass().getClassLoader());
        if (this.myClusterGroup != null && this.myClusterGroup.isConnected()) {
            log.info((Object)("addListener: " + listener + ".  Already connected, telling listener that we are joined."));
            try {
                listener.thisMemberJoinedTheGroup(this.getMyId(), this.myGroupType);
            }
            catch (Exception e) {
                log.warn((Object)"Exception joining group", (Throwable)e);
            }
        }
    }

    @Override
    public void removeListener(DataDistLayerListener listener) {
        WeakReference<DataDistLayerListener> weakListener;
        if (listener != null && (weakListener = this.listenerMap.get((Object)listener.getListenerAppId())) != null && listener == weakListener.get()) {
            this.listenerMap.remove((Object)listener.getListenerAppId());
            this.removeClassLoader(listener);
        }
    }

    @Override
    public void destroy() {
        log.info((Object)("Shutting down " + this.getClass().getSimpleName() + "'s loaded DDL Listeners."));
        if (this.listenerMap != null) {
            for (WeakReference<DataDistLayerListener> weakListener : this.listenerMap.values()) {
                DataDistLayerListener listener = (DataDistLayerListener)weakListener.get();
                if (listener == null) continue;
                log.info((Object)("Destroying listener " + listener.getClass().getSimpleName()));
                listener.destroy();
            }
        }
        log.info((Object)("Shutting down the " + this.getClass().getSimpleName() + " member"));
        this.leaveTheGroup(false);
        this.ddlFactory = null;
        this.myClusterLeaderId = null;
        this.listenerMap = null;
        JGroupEncoderDecoder.destroy();
        this.getTypeExecutor.cancel();
    }

    protected abstract void createGroup();

    protected void joinTheGroup() {
        if (this.myClusterGroup == null) {
            this.createGroup();
        }
        if (this.myClusterGroup != null) {
            if (this.myClusterGroup.isConnected()) {
                if (log.isFineEnabled()) {
                    log.fine((Object)"joinTheGroup: Got a request to join the group, but we already are.");
                }
            } else {
                this.myClusterGroup.connectGroup();
                if (log.isFinerEnabled()) {
                    log.finer((Object)"Channel connected");
                }
            }
        }
    }

    protected void removeClassLoader(DataDistLayerListener rmListener) {
        ClassLoader rmCl = rmListener.getClass().getClassLoader();
        for (WeakReference<DataDistLayerListener> weakListener : this.listenerMap.values()) {
            ClassLoader cl;
            DataDistLayerListener listener = (DataDistLayerListener)weakListener.get();
            if (listener == null || !(cl = listener.getClass().getClassLoader()).equals(rmCl)) continue;
            return;
        }
        JGroupEncoderDecoder.removeClassLoader(rmCl);
    }

    public void leaveTheGroup(boolean waitForClosed) {
        if (this.myClusterGroup != null) {
            if (waitForClosed) {
                this.myClusterGroup.destroy();
            } else {
                final GroupCommIntf tmpGroup = this.myClusterGroup;
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        Thread.currentThread().setName("DDLLeaveTheGroupThread");
                        tmpGroup.destroy();
                    }
                };
                thread.start();
            }
            this.myClusterGroup = null;
            this.myClusterMembers = new CopyOnWriteArrayList<DataDistLayerMemberAddr>();
            this.memberMapping = new ConcurrentHashMap<Object, DataDistLayerMemberAddr>();
            log.info((Object)("DataDistCluster destroyed and leaving the group: " + this.myClusterName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataDistLayerMemberAddr getMyId() {
        if (this.myAddr == null) {
            DataDistLayerMember dataDistLayerMember = this;
            synchronized (dataDistLayerMember) {
                if (this.myAddr == null) {
                    this.myAddr = new DataDistLayerMemberAddr(this.myClusterName, null, DDLUtilities.getManagementIP());
                }
            }
        }
        return this.myAddr;
    }

    @Override
    public List<DataDistLayerMemberAddr> getMembers() {
        return this.myClusterMembers;
    }

    @Override
    public void sendMessage(List<DataDistLayerMemberAddr> hostIds, DataDistLayerMessage message) throws DDLException {
        for (DataDistLayerMemberAddr host : hostIds) {
            message.setHost(host);
            this.sendMessage(host, message);
        }
    }

    public void multicastMessage(DataDistLayerMessage message, boolean isSynchronous) {
        if (message.getAppId() != DataDistLayerMessage.TargetAppId.INTERNAL) {
            if (this.myClusterGroup != null) {
                if (log.isFinestEnabled()) {
                    log.finest((Object)("multicastMessage appId=" + (Object)((Object)message.getAppId()) + " message=" + message.toString()));
                }
                this.myClusterGroup.multicastMessage(message, isSynchronous);
            } else {
                log.error((Object)("multicastMessage failed: myClusterGroup=null appId=" + (Object)((Object)message.getAppId()) + " message=" + message.toString()));
            }
        }
    }

    @Override
    public void multicastMessage(DataDistLayerMessage message) {
        this.multicastMessage(message, false);
    }

    @Override
    public Object queryHost(DataDistLayerMemberAddr member, DataDistLayerMessage message) {
        return this.queryHost(member, message, AsmSettings.getJGroupSingleHostQueryTimeout());
    }

    @Override
    public abstract Object queryHost(DataDistLayerMemberAddr var1, DataDistLayerMessage var2, int var3);

    public Object queryLeader(DataDistLayerMessage message) {
        return this.queryLeader(message, AsmSettings.getJGroupSingleHostQueryTimeout());
    }

    public Object queryLeader(DataDistLayerMessage message, int timeout) {
        if (this.myClusterLeaderId == null) {
            log.info((Object)"Leader ID is unknown at this time.");
            return null;
        }
        Object queryResult = null;
        if (this.myClusterGroup != null) {
            queryResult = this.myClusterGroup.queryTheHost(this.myClusterLeaderId, message, timeout);
        }
        return queryResult;
    }

    @Override
    public Map<DataDistLayerMemberAddr, Object> queryAllHosts(DataDistLayerMessage message) {
        return this.queryAllHosts(message, 10000);
    }

    @Override
    public Map<DataDistLayerMemberAddr, Object> queryAllHosts(DataDistLayerMessage message, int timeout) {
        Map tmpMap;
        HashMap<DataDistLayerMemberAddr, Object> retValue = new HashMap<DataDistLayerMemberAddr, Object>();
        if (this.myClusterGroup != null && (tmpMap = (Map)this.myClusterGroup.queryTheHost(null, message, timeout)) != null) {
            for (DataDistLayerMemberAddr mbr : this.getMembers()) {
                retValue.put(mbr, tmpMap.get(mbr.getHostId()));
            }
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object handleQuery(DataDistLayerMessage message, DataDistLayerMemberAddr srcMember) {
        if (message.getAppId() == DataDistLayerMessage.TargetAppId.INTERNAL) {
            switch (message.getMessageType()) {
                case 16: {
                    return true;
                }
                case 17: {
                    return this.getDDLVersion();
                }
            }
        } else {
            WeakReference<DataDistLayerListener> weakListener = this.listenerMap.get((Object)message.getAppId());
            DataDistLayerListener listener = weakListener == null ? null : (DataDistLayerListener)weakListener.get();
            ClassLoader origCl = Thread.currentThread().getContextClassLoader();
            if (listener != null) {
                ClassLoader listenerCl = listener.getClass().getClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(listenerCl);
                    Object object = listener.handleMessage(message, srcMember);
                    return object;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(origCl);
                }
            }
            this.listenerMap.remove((Object)message.getAppId());
        }
        return null;
    }

    protected boolean handleNewMember(DataDistLayerMemberAddr member, String newMemberType) {
        boolean isFullyResolved = true;
        if (log.isInfoEnabled()) {
            if (newMemberType == null || "Console".equals(newMemberType)) {
                if (log.isFineEnabled()) {
                    log.fine((Object)("new member (" + newMemberType + ") joined the group: " + member));
                }
            } else {
                log.info((Object)("new member (" + newMemberType + ") joined the group: " + member));
            }
        }
        if (this.myClusterGroup != null && this.myClusterGroup.isConnected()) {
            if (this.myClusterGroup.getThisHostId().equals(member.getHostId())) {
                DataDistLayerMemberAddr oldAddr = this.myAddr == null ? null : new DataDistLayerMemberAddr(this.myAddr);
                this.getMyId().setHostId(this.myClusterGroup.getThisHostId());
                this.getMyId().setMemberType(this.myMemberType);
                this.getMyId().setMemberVersion(this.getDDLVersion());
                this.getMyId().setClusterName(this.myClusterName);
                if (log.isFineEnabled()) {
                    log.fine((Object)("handleNewMember: Updating our ID from " + oldAddr + " to " + this.getMyId()));
                }
                member.setMemberType(this.myMemberType);
                member.setMemberIpAddr(DDLUtilities.getManagementIP());
                member.setMemberVersion(this.getDDLVersion());
                for (DataDistLayerMemberAddr dataDistLayerMemberAddr : this.myClusterMembers) {
                    if (dataDistLayerMemberAddr == member) continue;
                    this.sendMyType(dataDistLayerMemberAddr);
                }
                for (WeakReference weakReference : this.listenerMap.values()) {
                    DataDistLayerListener listener = (DataDistLayerListener)weakReference.get();
                    if (listener == null) continue;
                    try {
                        listener.thisMemberJoinedTheGroup(member, this.myGroupType);
                    }
                    catch (Exception e) {
                        log.error((Object)("Error processing " + listener.getClass().getSimpleName() + "'s thisMemberJoinedTheGroup."), (Throwable)e);
                    }
                }
            } else if (newMemberType != null) {
                member.setMemberType(newMemberType);
                for (WeakReference<DataDistLayerListener> weakListener : this.listenerMap.values()) {
                    DataDistLayerListener dataDistLayerListener = (DataDistLayerListener)weakListener.get();
                    if (dataDistLayerListener == null) continue;
                    try {
                        dataDistLayerListener.otherMemberJoined(member, this.myGroupType);
                    }
                    catch (Exception e) {
                        log.error((Object)("Error processing " + dataDistLayerListener.getClass().getSimpleName() + "'s otherMemberJoined."), (Throwable)e);
                    }
                }
                this.newMemberFullyResolved(member);
            } else {
                isFullyResolved = false;
                if (log.isFinestEnabled()) {
                    log.finest((Object)"handleNewMember: Dont know member's type yet, delaying the processing in case it is coming up for the first time.");
                }
                this.getTypeExecutor.schedule((TimerTask)new DDLMemberDelayedTypeChecker(member, this), LocalSettings.getJGroupTypeRetryInterval(), (long)LocalSettings.getJGroupTypeRetryInterval());
            }
        } else {
            isFullyResolved = false;
            log.fine((Object)"handleNewMember: Group is not connected yet, skipping");
        }
        return isFullyResolved;
    }

    protected void handleDroppedMember(DataDistLayerMemberAddr member) {
        if ("Console".equals(member.getMemberType())) {
            if (log.isFineEnabled()) {
                log.fine((Object)("member left the group: " + member));
            }
        } else {
            log.info((Object)("member left the group: " + member));
        }
        for (WeakReference<DataDistLayerListener> weakListener : this.listenerMap.values()) {
            DataDistLayerListener listener = (DataDistLayerListener)weakListener.get();
            if (listener == null) continue;
            listener.hostLeftTheGroup(member, this.myGroupType);
        }
    }

    @Override
    public void membershipChanged(String clusterName, List<Object> newMembers) {
        if (clusterName.equals(this.myClusterName)) {
            if (this.myClusterGroup == null) {
                log.warn((Object)"membershipChange: Recieved newMembers/view during shutdown!");
                return;
            }
            if (!this.myClusterGroup.isConnected()) {
                log.error((Object)("membershipChanged: Channel is not connected, but will process anyway. Cluster=" + clusterName + ", members=" + newMembers));
            }
            ArrayList<DataDistLayerMemberAddr> tmpMyClusterMembers = new ArrayList<DataDistLayerMemberAddr>();
            if (log.isFineEnabled()) {
                log.fine((Object)("membershipChanged: Connected and proceeding for cluster <" + this.myClusterName + "> with ID " + this.getMyId() + " is processing group membership changes: " + newMembers));
            }
            ArrayList<DataDistLayerMemberAddr> addedMembers = new ArrayList<DataDistLayerMemberAddr>();
            for (Object address : newMembers) {
                DataDistLayerMemberAddr member = new DataDistLayerMemberAddr(this.myClusterName, address);
                if (!this.myClusterMembers.contains(member)) {
                    tmpMyClusterMembers.add(member);
                    addedMembers.add(member);
                    continue;
                }
                DataDistLayerMemberAddr ddlAddr = this.myClusterMembers.get(this.myClusterMembers.indexOf(member));
                ddlAddr.setHostId(address);
                tmpMyClusterMembers.add(ddlAddr);
            }
            ArrayList<DataDistLayerMemberAddr> deletedMembers = new ArrayList<DataDistLayerMemberAddr>();
            for (DataDistLayerMemberAddr member : this.myClusterMembers) {
                if (newMembers.contains(member.getHostId())) continue;
                deletedMembers.add(member);
            }
            this.myClusterMembers = tmpMyClusterMembers;
            for (DataDistLayerMemberAddr member : addedMembers) {
                this.memberMapping.put(member.getHostId(), member);
                this.handleNewMember(member, null);
            }
            for (DataDistLayerMemberAddr member : deletedMembers) {
                this.memberMapping.remove(member.getHostId());
                this.handleDroppedMember(member);
            }
        }
        if (log.isFinestEnabled()) {
            log.finest((Object)("DDL Member List: " + this.myClusterMembers));
        }
    }

    @Override
    public DataDistLayerMemberAddr getDDLMemberFromAddress(Object addr) {
        DataDistLayerMemberAddr srcMember = this.memberMapping.get(addr);
        if (srcMember == null) {
            srcMember = new DataDistLayerMemberAddr(this.myClusterName, addr);
        }
        return srcMember;
    }

    protected void sendMessageToAll(DataDistLayerMessage msg) {
        for (DataDistLayerMemberAddr addr : this.getMembers()) {
            if (addr.equals(this.getMyId())) continue;
            try {
                this.sendMessage(addr, msg);
            }
            catch (DDLException e) {
                log.error((Object)("Failed to send message: " + msg));
            }
        }
    }

    protected void processInternalMessage(DataDistLayerMessage message, DataDistLayerMemberAddr sender) throws DDLException {
        switch (message.getMessageType()) {
            case 10: {
                List tempList = (List)((Object)message.getPayload());
                DataDistLayerMemberAddr targetHost = (DataDistLayerMemberAddr)tempList.get(0);
                DataDistLayerMessage originalMessage = (DataDistLayerMessage)tempList.get(1);
                this.sendMessage(targetHost, originalMessage);
                break;
            }
            case 20: {
                HashMap memberTypeMap = (HashMap)message.getPayload();
                String memberType = (String)memberTypeMap.get("TYPE_NAME");
                Double memberVersion = (Double)memberTypeMap.get("VERSION");
                String memberIpAddr = (String)memberTypeMap.get("IP_ADDRESS");
                boolean foundMember = false;
                if (log.isFinerEnabled()) {
                    log.finer((Object)("processInternalMessage: Got SET_MEMBER_TYPE[" + memberType + "] for member with hostId " + sender.getHostId()));
                }
                for (DataDistLayerMemberAddr member : this.myClusterMembers) {
                    if (!member.equals(sender)) continue;
                    foundMember = true;
                    if (member.getMemberType() == null && memberType != null) {
                        member.setMemberVersion(memberVersion);
                        member.setMemberIpAddr(memberIpAddr);
                        if (!this.handleNewMember(member, memberType)) {
                            log.fine((Object)("Member still not fully resolved, this may be problematic unless this is received during the initial connection: " + member + ", type=" + memberType));
                        }
                    } else if (log.isFinerEnabled()) {
                        log.finer((Object)("processInternalMessage: already know their type (" + memberType + ")"));
                    }
                    if (!memberTypeMap.containsKey("NEED_YOUR_TYPE")) break;
                    this.sendMyType(member);
                    break;
                }
                if (foundMember) break;
                log.warn((Object)("processInternalMessage: Unable to process member's type because it didn't exist in our list of members: " + this.myClusterMembers + ". Missing: " + sender));
                break;
            }
            case 26: {
                log.info((Object)("Changing version of jgroups to: " + message.getPayload()));
                this.ddlFactory.changeJgroupVersion((String)((Object)message.getPayload()));
                break;
            }
            default: {
                log.warn((Object)(sender + " received INTERNAL message that could not be processed: " + message));
            }
        }
    }

    protected void newMemberFullyResolved(DataDistLayerMemberAddr addr) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivedMessage(DataDistLayerMessage message, DataDistLayerMemberAddr sender) {
        DataDistLayerMemberAddr destination = message.getHost();
        if (destination != null && destination.getHostId() != null && !destination.equals(this.getMyId())) {
            block14: {
                if (log.isFinestEnabled()) {
                    log.finest((Object)("forwarding message intended for " + destination));
                }
                try {
                    this.sendMessage(destination, message);
                }
                catch (DDLException e) {
                    if (!log.isFinerEnabled()) break block14;
                    log.warn((Object)("Failed to forward " + message + " to " + destination), (Throwable)e);
                }
            }
            return;
        }
        switch (message.getAppId()) {
            case INTERNAL: {
                if (log.isFinestEnabled()) {
                    log.finest((Object)("Received INTERNAL message from sender: " + sender));
                }
                try {
                    this.processInternalMessage(message, sender);
                }
                catch (DDLException e) {
                    log.warn((Object)"DDL failed processing an internal message", (Throwable)e);
                }
                break;
            }
            default: {
                DataDistLayerListener listener;
                WeakReference<DataDistLayerListener> weakListener = this.listenerMap.get((Object)message.getAppId());
                DataDistLayerListener dataDistLayerListener = listener = weakListener == null ? null : (DataDistLayerListener)weakListener.get();
                if (listener != null) {
                    ClassLoader origCl = Thread.currentThread().getContextClassLoader();
                    ClassLoader listenerCl = listener.getClass().getClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(listenerCl);
                        listener.processMessage(message, sender);
                        break;
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(origCl);
                    }
                }
                if (!log.isFineEnabled()) break;
                log.fine((Object)("Message from " + sender + " could not be mapped to a listener, discarding: " + message));
            }
        }
    }

    protected void sendMyType(DataDistLayerMemberAddr member) {
        if (log.isFinerEnabled()) {
            log.finer((Object)("sendMyType: Sending my type to " + member));
        }
        HashMap<String, Object> myTypeMap = new HashMap<String, Object>();
        myTypeMap.put("TYPE_NAME", this.myMemberType);
        myTypeMap.put("VERSION", this.getDDLVersion());
        myTypeMap.put("IP_ADDRESS", DDLUtilities.getManagementIP());
        if (member.getMemberType() == null) {
            myTypeMap.put("NEED_YOUR_TYPE", "true");
        }
        DataDistLayerMessage message = new DataDistLayerMessage(DataDistLayerMessage.TargetAppId.INTERNAL, 20, myTypeMap);
        this.myClusterGroup.sendAsyncMessage(member.getHostId(), message);
    }

    public Map<DataDistLayerMessage.TargetAppId, DataDistLayerListener> getListenerMap() {
        HashMap<DataDistLayerMessage.TargetAppId, DataDistLayerListener> map = new HashMap<DataDistLayerMessage.TargetAppId, DataDistLayerListener>();
        for (Map.Entry<DataDistLayerMessage.TargetAppId, WeakReference<DataDistLayerListener>> e : this.listenerMap.entrySet()) {
            DataDistLayerListener listener = (DataDistLayerListener)e.getValue().get();
            if (listener == null) continue;
            map.put(e.getKey(), listener);
        }
        return map;
    }

    public Object getJGroupView() {
        return this.myClusterGroup == null ? null : this.myClusterGroup.getCurrentView();
    }

    protected void setDDLFactory(DataDistLayerFactory ddlFactory) {
        this.ddlFactory = ddlFactory;
    }

    public Map<Object, DataDistLayerMemberAddr> getMemberMapping() {
        return this.memberMapping;
    }

    public StringBuilder dumpJGroupsQueues(boolean dumpContents) {
        return this.myClusterGroup.dumpStats(dumpContents);
    }

    public void updateLogicalNames() {
        this.myClusterGroup.updateLogicalNames();
    }
}

