/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.datadistributionlayer;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.AsmSettings;
import com.avaya.asm.datamgr.datadistributionlayer.DDLInterClusterMember;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerFactory;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMemberAddr;
import com.avaya.common.logging.client.Logger;
import java.util.List;
import java.util.TimerTask;
import java.util.Vector;

public class FragmentationAudit
extends TimerTask {
    protected static final Logger log = AsmLogger.getLogger(FragmentationAudit.class);
    private boolean runNow;

    public FragmentationAudit() {
        this.runNow = false;
    }

    public FragmentationAudit(boolean runNow) {
        this.runNow = runNow;
    }

    @Override
    public void run() {
        DDLInterClusterMember interMember = DataDistLayerFactory.getInstance().getInterClusterMember();
        if (!this.runNow) {
            Long timeSinceLastBroadcast;
            Long minSleepBetween;
            Long sleepTime = minSleepBetween = Long.valueOf(AsmSettings.getFragAuditInterval() / 10L);
            if (log.isFineEnabled()) {
                log.fine((Object)("Starting the Fragmentation Audit, spaced every " + minSleepBetween / 1000L + " sec."));
            }
            if ((timeSinceLastBroadcast = Long.valueOf(System.currentTimeMillis() - interMember.lastTimeViewRequested)) < minSleepBetween) {
                sleepTime = minSleepBetween - timeSinceLastBroadcast + 5000L;
                interMember.restartFragmentationAudit(sleepTime);
                if (log.isFineEnabled()) {
                    log.fine((Object)("Delaying the execution of this audit, due to another member's recent run, by " + AsmSettings.getFragAuditInterval() / 1000L + " seconds."));
                }
                return;
            }
        }
        try {
            interMember.updateLogicalNames();
            if (!this.checkThresholds(interMember) && log.isFineEnabled()) {
                log.fine((Object)"Cluster appears to be in order, no rejoining necessary.");
            }
        }
        catch (Exception e) {
            log.error((Object)"Unhandled exception: ", (Throwable)e);
        }
    }

    protected boolean checkThresholds(DDLInterClusterMember interMember) {
        boolean rejoined = false;
        if (interMember != null) {
            List<DataDistLayerMemberAddr> members = interMember.getMembers();
            Vector<String> provisionedMembers = interMember.interHelper.getInterClusterMemberIPs();
            if (members != null && provisionedMembers != null) {
                double rejoinThreshold;
                double currentThreshold;
                int numProvisionedMembers = provisionedMembers.size();
                int numActualMembers = members.size();
                if (numProvisionedMembers == 0) {
                    log.warn((Object)"There are no provisioned core members.");
                    numProvisionedMembers = 1;
                }
                if (log.isFinestEnabled()) {
                    log.finest((Object)("Expected cluster size=" + numProvisionedMembers + " and actual size=" + numActualMembers));
                }
                if ((currentThreshold = (double)numActualMembers / (double)numProvisionedMembers) <= (rejoinThreshold = AsmSettings.getFragRejoinThreshold().doubleValue())) {
                    log.warn((Object)("We are suspecting that the inter cluster is fragmented.  Rejoining the inter cluster now.  Current threshold is " + currentThreshold * 100.0 + "% (vs. " + rejoinThreshold * 100.0 + "%)"));
                    rejoined = true;
                    DataDistLayerFactory.getInstance().rejoinMember(interMember);
                } else if (log.isFinestEnabled()) {
                    log.finest((Object)("Audit ran and determined that we are in the majority cluster.  No corrective action necessary.  Current threshold is " + currentThreshold * 100.0 + "% (vs. " + rejoinThreshold * 100.0 + "%)"));
                }
            }
        }
        return rejoined;
    }
}

