/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.datadistributionlayer;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.datadistributionlayer.BlockingWaitNotifyQueue;
import com.avaya.asm.datamgr.datadistributionlayer.GroupCommIntf;
import com.avaya.asm.datamgr.datadistributionlayer.GroupCommListener;
import com.avaya.common.logging.client.Logger;

public class MembershipChangedThread
extends Thread {
    private GroupCommListener listener;
    private BlockingWaitNotifyQueue<Object> messageQueue;
    private GroupCommIntf myWrapper;
    private boolean canRun = false;
    protected final Logger log = AsmLogger.getLogger(MembershipChangedThread.class);

    public MembershipChangedThread(GroupCommListener listener, GroupCommIntf myWrapper) {
        super("MembershipChangedThread");
        this.listener = listener;
        this.myWrapper = myWrapper;
        this.messageQueue = new BlockingWaitNotifyQueue();
        this.canRun = true;
    }

    @Override
    public void run() {
        while (this.canRun) {
            try {
                Object new_view = this.messageQueue.poll();
                this.waitOnChannelConnect();
                if (!this.canRun) continue;
                this.myWrapper.setView(new_view);
                if (this.log.isFineEnabled()) {
                    this.log.fine((Object)("====>> " + this.myWrapper.getGroupName() + " revised view: \n" + new_view));
                }
                this.listener.membershipChanged(this.myWrapper.getGroupName(), this.myWrapper.getCurrentMembers());
            }
            catch (InterruptedException e) {
                this.log.error((Object)"Interrupted unexpectedly!", (Throwable)e);
            }
            catch (Exception e) {
                this.log.error((Object)("run() threw an exception for: " + this.myWrapper.getGroupName()), (Throwable)e);
            }
        }
    }

    public int addToQueue(Object e) {
        this.messageQueue.add(e);
        return this.messageQueue.size();
    }

    public void setMessageQueue(BlockingWaitNotifyQueue<Object> messageQueue) {
        this.messageQueue = messageQueue;
    }

    public synchronized void channelNowConnected() {
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)"Notified externally that channel should be connected.");
        }
        this.notify();
    }

    public synchronized void waitOnChannelConnect() {
        while (!this.myWrapper.isConnected() && this.canRun) {
            try {
                this.wait(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void destroy() {
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Destroying the MembershipChanged processing thread " + this.getName()));
        }
        this.canRun = false;
        this.messageQueue.stop();
    }

    public BlockingWaitNotifyQueue<Object> getQueue() {
        return this.messageQueue;
    }
}

