/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.helpers;

import java.io.UnsupportedEncodingException;

public class StringArrayBytes {
    static final String charSet = "UTF-8";
    static final short nullLength = Short.MAX_VALUE;
    static final int maxStringLength = 32766;
    static final short lastNullBit = 16384;
    static final int maxNumStrings = 16383;
    static final int nullLengthSize = StringArrayBytes.valueLength((short)Short.MAX_VALUE);

    private static int shortToBytes(short value, byte[] arr, int offset) {
        int len = 1;
        arr[offset] = (byte)(value & 0x7F);
        if (StringArrayBytes.valueLength(value) == 2) {
            int n = offset;
            arr[n] = (byte)(arr[n] | 0x80);
            arr[offset + 1] = (byte)((value & 0x7F80) >> 7);
            ++len;
        }
        return len;
    }

    private static short bytesToShort(byte[] arr, int offset) {
        short value = (short)(arr[offset] & 0x7F);
        if (StringArrayBytes.valueLength(arr, offset) == 2) {
            value = (short)(value | (short)(arr[offset + 1] << 7 & Short.MAX_VALUE));
        }
        return value;
    }

    private static int valueLength(byte[] arr, int offset) {
        int len = 1;
        if ((arr[offset] & 0x80) != 0) {
            ++len;
        }
        return len;
    }

    private static int valueLength(short value) {
        int len = 1;
        if ((value & 0xFFFFFF80) != 0) {
            ++len;
        }
        return len;
    }

    public static byte[] encode(String ... strArray) {
        int numStrings = strArray.length;
        boolean lastStringNull = false;
        if (numStrings > 16383) {
            String msg = "number of Strings (" + numStrings + ") exceeds maximum number of Strings that can be stored (" + 16383 + ").";
            throw new IllegalArgumentException(msg);
        }
        byte[][] byteArrays = new byte[numStrings][];
        int idx = 0;
        int dataLength = 0;
        int sizeLength = 0;
        int lastElem = strArray.length - 1;
        for (String str : strArray) {
            if (str != null) {
                try {
                    byteArrays[idx] = str.getBytes(charSet);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                int len = byteArrays[idx].length;
                if (len > 32766) {
                    String msg = "length of encoded String (" + len + ") indexed at " + idx + " exceeds maximum length of String that can be stored (" + 32766 + ").";
                    throw new IllegalArgumentException(msg);
                }
                dataLength += len;
                sizeLength = idx != lastElem ? (sizeLength += StringArrayBytes.valueLength((short)len)) : (sizeLength += StringArrayBytes.valueLength((short)numStrings));
            } else {
                byteArrays[idx] = null;
                if (idx != lastElem) {
                    sizeLength += nullLengthSize;
                } else {
                    lastStringNull = true;
                    sizeLength += StringArrayBytes.valueLength((short)(numStrings | 0x4000));
                }
            }
            ++idx;
        }
        byte[] bytes = new byte[dataLength + sizeLength];
        int pos = 0;
        pos += StringArrayBytes.shortToBytes((short)(lastStringNull ? numStrings | 0x4000 : numStrings), bytes, pos);
        for (idx = 0; idx < numStrings; ++idx) {
            if (byteArrays[idx] != null) {
                if (idx < numStrings - 1) {
                    pos += StringArrayBytes.shortToBytes((short)byteArrays[idx].length, bytes, pos);
                }
                System.arraycopy(byteArrays[idx], 0, bytes, pos, byteArrays[idx].length);
                pos += byteArrays[idx].length;
                byteArrays[idx] = null;
                continue;
            }
            if (idx >= numStrings - 1) continue;
            pos += StringArrayBytes.shortToBytes((short)Short.MAX_VALUE, bytes, pos);
        }
        return bytes;
    }

    static String[] decode(byte[] bytes) {
        int numStrings = StringArrayBytes.getNumStrings(bytes);
        String[] strArray = new String[numStrings];
        int pos = StringArrayBytes.valueLength(bytes, 0);
        for (int idx = 0; idx < numStrings; ++idx) {
            try {
                int len;
                if (idx + 1 == numStrings) {
                    len = (short)(bytes.length - pos);
                    if (len == 0 && StringArrayBytes.isLastStringNull(bytes)) {
                        len = Short.MAX_VALUE;
                    }
                } else {
                    len = StringArrayBytes.bytesToShort(bytes, pos);
                    pos += StringArrayBytes.valueLength((short)len);
                }
                if (len != Short.MAX_VALUE) {
                    strArray[idx] = new String(bytes, pos, len, charSet);
                    pos += len;
                    continue;
                }
                strArray[idx] = null;
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return strArray;
    }

    public static String getString(byte[] bytes, int strIdx) {
        int len;
        short numStrings = StringArrayBytes.getNumStrings(bytes);
        if (strIdx >= numStrings) {
            String msg = "index " + strIdx + " exceeds number of Strings (" + numStrings + ").";
            throw new ArrayIndexOutOfBoundsException(msg);
        }
        int pos = StringArrayBytes.valueLength(bytes, 0);
        for (int i = 0; i < strIdx; ++i) {
            len = StringArrayBytes.bytesToShort(bytes, pos);
            pos += StringArrayBytes.valueLength((short)len);
            if (len == Short.MAX_VALUE) continue;
            pos += len;
        }
        if (strIdx + 1 == numStrings) {
            len = (short)(bytes.length - pos);
            if (len == 0 && StringArrayBytes.isLastStringNull(bytes)) {
                len = Short.MAX_VALUE;
            }
        } else {
            len = StringArrayBytes.bytesToShort(bytes, pos);
            pos += StringArrayBytes.valueLength((short)len);
        }
        String str = null;
        if (len != Short.MAX_VALUE) {
            try {
                str = new String(bytes, pos, len, charSet);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return str;
    }

    public static byte[] setString(byte[] bytes, String newStr, int strIdx) {
        int newLenSize;
        int lenSize;
        int newLen;
        int numStrings = StringArrayBytes.getNumStrings(bytes);
        if (strIdx >= numStrings) {
            String msg = "index " + strIdx + " exceeds number of Strings (" + numStrings + ").";
            throw new ArrayIndexOutOfBoundsException(msg);
        }
        byte[] newStrBytes = null;
        if (newStr != null) {
            try {
                newStrBytes = newStr.getBytes(charSet);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            newLen = newStrBytes.length;
            if (newLen > 32766) {
                String msg = "length of encoded String (" + newLen + ") exceeds maximum length of String that can be stored (" + 32766 + ").";
                throw new IllegalArgumentException(msg);
            }
        } else {
            newLen = Short.MAX_VALUE;
        }
        int len = 0;
        int pos = StringArrayBytes.valueLength(bytes, 0);
        boolean lastStringNull = StringArrayBytes.isLastStringNull(bytes);
        int adjustNumStringsLen = 0;
        int newNumStrings = 0;
        int startOld = 0;
        int startNew = 0;
        if (strIdx + 1 == numStrings) {
            if (lastStringNull) {
                if (newStr != null && pos == nullLengthSize) {
                    newNumStrings = numStrings;
                    startOld = nullLengthSize;
                    startNew = StringArrayBytes.valueLength((short)newNumStrings);
                    adjustNumStringsLen = startNew - startOld;
                }
            } else if (newStr == null && pos != nullLengthSize) {
                newNumStrings = numStrings | 0x4000;
                startOld = StringArrayBytes.valueLength((short)numStrings);
                startNew = nullLengthSize;
                adjustNumStringsLen = startNew - startOld;
            }
        }
        for (int i = 0; i < strIdx; ++i) {
            len = StringArrayBytes.bytesToShort(bytes, pos);
            pos += StringArrayBytes.valueLength((short)len);
            if (len == Short.MAX_VALUE) continue;
            pos += len;
        }
        if (strIdx + 1 == numStrings) {
            len = bytes.length - pos;
            if (len == 0 && StringArrayBytes.isLastStringNull(bytes)) {
                len = Short.MAX_VALUE;
            }
        } else {
            len = StringArrayBytes.bytesToShort(bytes, pos);
        }
        if (strIdx + 1 == numStrings) {
            lenSize = 0;
            newLenSize = 0;
        } else {
            lenSize = len == Short.MAX_VALUE ? nullLengthSize : StringArrayBytes.valueLength((short)len);
            newLenSize = newLen == Short.MAX_VALUE ? nullLengthSize : StringArrayBytes.valueLength((short)newLen);
        }
        int totalLen = lenSize + (len == Short.MAX_VALUE ? 0 : len);
        int totalNewLen = newLenSize + (newLen == Short.MAX_VALUE ? 0 : newLen);
        if (totalLen == totalNewLen) {
            if (adjustNumStringsLen != 0) {
                System.arraycopy(bytes, startOld, bytes, startNew, bytes.length);
                pos += adjustNumStringsLen;
            }
            if (newNumStrings != 0) {
                StringArrayBytes.shortToBytes((short)newNumStrings, bytes, 0);
            }
            if (len != newLen) {
                if (strIdx + 1 < numStrings) {
                    pos += StringArrayBytes.shortToBytes((short)newLen, bytes, pos);
                }
            } else if (strIdx + 1 < numStrings) {
                pos += lenSize;
            }
            if (newStrBytes != null) {
                System.arraycopy(newStrBytes, 0, bytes, pos, newLen);
            }
            return bytes;
        }
        byte[] newBytes = new byte[bytes.length + totalNewLen - totalLen + adjustNumStringsLen];
        System.arraycopy(bytes, startOld, newBytes, startNew, pos - startOld);
        if (newNumStrings != 0) {
            StringArrayBytes.shortToBytes((short)newNumStrings, newBytes, 0);
        }
        int newPos = pos + adjustNumStringsLen;
        if (strIdx + 1 < numStrings) {
            newPos += StringArrayBytes.shortToBytes((short)newLen, newBytes, newPos);
        }
        if (newStrBytes != null) {
            System.arraycopy(newStrBytes, 0, newBytes, newPos, newLen);
            newPos += newLen;
        }
        if (strIdx + 1 < numStrings) {
            System.arraycopy(bytes, pos + totalLen, newBytes, newPos, bytes.length - (pos + totalLen));
        }
        return newBytes;
    }

    private static short getNumStrings(byte[] bytes) {
        return (short)(StringArrayBytes.bytesToShort(bytes, 0) & 0xFFFFBFFF);
    }

    private static boolean isLastStringNull(byte[] bytes) {
        return (StringArrayBytes.bytesToShort(bytes, 0) & 0x4000) != 0;
    }

    public static boolean equals(byte[] lhs, byte[] rhs) {
        if (lhs == null) {
            return rhs == null;
        }
        if (rhs == null) {
            return false;
        }
        if (lhs.length != rhs.length) {
            return false;
        }
        for (int i = 0; i < lhs.length; ++i) {
            if (lhs[i] == rhs[i]) continue;
            return false;
        }
        return true;
    }
}

