/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.loadrules;

import com.avaya.asm.datamgr.loadrules.LoadRule;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public class DataMgrLoadRules {
    private final String dataMgrInterfaceClass;
    private String dataMgrImplementationClass = null;
    private boolean isPermanentDataMgr = false;
    private Map<String, LoadRule> loadRulesByClassLoader = new WeakHashMap<String, LoadRule>();

    public DataMgrLoadRules(String dmInterfaceClass) {
        this.dataMgrInterfaceClass = dmInterfaceClass;
    }

    public String getDataMgrInterfaceClass() {
        return this.dataMgrInterfaceClass;
    }

    public String getDataMgrImplementationClass() {
        return this.dataMgrImplementationClass;
    }

    public boolean isPermanentDataMgr() {
        return this.isPermanentDataMgr;
    }

    public void addLoadRule(String classLoaderId, LoadRule loadRule) {
        String dataMgrImplementationClass;
        if (loadRule.isPermanentDataMgr()) {
            this.isPermanentDataMgr = true;
        }
        if ((dataMgrImplementationClass = loadRule.getDataMgrImplementationClass()) != null) {
            this.dataMgrImplementationClass = dataMgrImplementationClass;
        }
        this.loadRulesByClassLoader.put(classLoaderId, loadRule);
    }

    public Map<String, LoadRule> getLoadRules() {
        return Collections.unmodifiableMap(this.loadRulesByClassLoader);
    }

    public LoadRule getLoadRule(String classLoaderId) {
        return this.loadRulesByClassLoader.get(classLoaderId);
    }

    public String toString() {
        return "DataMgrLoadRules[dataMgrInterfaceClass=" + this.dataMgrInterfaceClass + ", dataMgrImplementationClass=" + this.dataMgrImplementationClass + ", isPermanentDataMgr=" + this.isPermanentDataMgr + ", loadRulesByClassLoader=" + this.loadRulesByClassLoader;
    }
}

