/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.objectapi.DigitMapRouterMatcher;
import com.avaya.asm.datamgr.objectapi.DigitMapRow;
import com.avaya.asm.datamgr.objectapi.DigitTree;
import com.avaya.common.logging.client.LogLevel;
import com.avaya.common.logging.client.Logger;
import java.io.Serializable;

public class DigitMapRouter
extends DigitTree<DigitMapRow>
implements Serializable {
    private static final Logger log = AsmLogger.getLogger(DigitMapRouter.class);
    private static final long serialVersionUID = 4172685182703741357L;

    public void insert(String digits, short min, short max, DigitMapRow row) {
        this.insert(digits, min, max, row, new DigitMapRouterMatcher(row));
    }

    public void delete(String digits, short min, short max, DigitMapRow row) {
        this.delete(digits, min, max, new DigitMapRouterMatcher(row));
    }

    public void update(String digits, short min, short max, DigitMapRow row) {
        this.update(digits, min, max, row, new DigitMapRouterMatcher(row));
    }

    public DigitMapRow findBestMatch(String digits) {
        return super.findBestMatch(digits, new DigitMapRouterMatcher(null));
    }

    public Long getRoute(String digits) {
        DigitMapRow row = this.findBestMatch(digits);
        if (log.isFineEnabled()) {
            log.fine((Object)("getRoute(\"" + digits + "\") found " + row));
        }
        return row == null ? null : Long.valueOf(row.getId());
    }

    public String toString() {
        return this.dumpTree();
    }

    public static void setLogLevelForJUnit() {
        log.setLevel(LogLevel.INFO);
    }
}

