/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.core.AsmConstants;
import com.avaya.asm.core.FeatureTags;
import com.avaya.asm.datamgr.objectapi.IPAddress;
import com.avaya.asm.datamgr.objectapi.MonitorTransition;
import com.avaya.asm.datamgr.objectapi.MonitorTransitions;
import com.avaya.asm.datamgr.objectapi.MonitoredEntity;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class MonitoredAddress
implements Serializable {
    private static final long serialVersionUID = -3783929257021009191L;
    private final transient MonitoredEntity entity;
    private final String ipaddress;
    private final int port;
    private final AsmConstants.TRANSPORT transport;
    private volatile Status status = Status.INITIALIZING;
    private volatile boolean denyNewService = false;
    private volatile int downCount = 0;
    private volatile AtomicLong sentOptions = new AtomicLong(0L);
    private volatile String callId = null;
    private volatile AtomicLong lastResponse = new AtomicLong(0L);
    private volatile AtomicLong responseMs = new AtomicLong(0L);
    private volatile String reason = null;
    private volatile int retryAfter = 0;
    private volatile Integer loadFactor = null;
    private volatile int upCount = 0;
    private static final char KEY_DELIMITER = ';';
    public static final int SAVED_TRANSITIONS = 20;
    private final MonitorTransitions<Status> transitions = new MonitorTransitions(20);

    public MonitoredAddress(MonitoredEntity entity, String ipaddress, int port, AsmConstants.TRANSPORT transport, boolean denyNewService) {
        this.entity = entity;
        this.ipaddress = ipaddress;
        this.port = port;
        this.transport = transport;
        this.denyNewService = denyNewService;
    }

    public MonitoredAddress(String ipaddress, int port, AsmConstants.TRANSPORT transport) {
        this.entity = null;
        this.ipaddress = ipaddress;
        this.port = port;
        this.transport = transport;
    }

    public MonitoredEntity getEntity() {
        return this.entity;
    }

    public String getIpaddress() {
        return this.ipaddress;
    }

    public int getPort() {
        return this.port;
    }

    public AsmConstants.TRANSPORT getTransport() {
        return this.transport;
    }

    public static String createKey(String ipaddress, int port, AsmConstants.TRANSPORT transport) {
        if (ipaddress == null) {
            return null;
        }
        String expandedAddr = IPAddress.toExpandedForm(ipaddress);
        StringBuilder s = new StringBuilder(expandedAddr);
        s.append(';');
        s.append(Integer.toString(port));
        s.append(';');
        s.append((Object)transport);
        return s.toString();
    }

    public static String getAddressFromKey(String key) {
        return key.substring(0, key.indexOf(59));
    }

    public static int getPortFromKey(String key) {
        return Integer.parseInt(key.substring(key.indexOf(59) + 1, key.lastIndexOf(59)));
    }

    public static String getTransportFromKey(String key) {
        return key.substring(key.lastIndexOf(59) + 1);
    }

    public String getKey() {
        return MonitoredAddress.createKey(this.ipaddress, this.port, this.transport);
    }

    public List<MonitorTransition<Status>> getTransitions() {
        return this.transitions.getTransitions();
    }

    public long getLastTransitionToUp() {
        return this.transitions.getLastTransitionOfType(Status.UP);
    }

    public long getLastTransitionToDown() {
        return this.transitions.getLastTransitionOfType(Status.DOWN);
    }

    public void setLastTransitionToUp(long lastTransitionToUp) {
        this.lastResponse.set(lastTransitionToUp);
        this.transitions.update(Status.UP, this.reason, lastTransitionToUp);
    }

    public void setLastTransitionToDown(long lastTransitionToDown) {
        this.lastResponse.set(lastTransitionToDown);
        this.transitions.update(Status.DOWN, this.reason, lastTransitionToDown);
    }

    public int getDownCount() {
        return this.downCount;
    }

    public int getUpCount() {
        return this.upCount;
    }

    public long getSentOptions() {
        return this.sentOptions.get();
    }

    public void setSentOptions(long sentOptions) {
        this.sentOptions.set(sentOptions);
    }

    public String getCallId() {
        return this.callId;
    }

    public void setCallId(String callId) {
        this.callId = callId;
    }

    public long getLastResponse() {
        return this.lastResponse.get();
    }

    public void setLastResponse(long lastResponse) {
        this.lastResponse.set(lastResponse);
    }

    public long getResponseMs() {
        return this.responseMs.get();
    }

    public void setResponseMs(long responseMs) {
        this.responseMs.set(responseMs);
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public int getRetryAfter() {
        return this.retryAfter;
    }

    public Integer getLoadFactor() {
        return this.loadFactor;
    }

    public void setLoadFactor(Integer loadFactor) {
        this.loadFactor = loadFactor;
    }

    public Boolean matchesResponseHandling(String response) {
        return this.entity.matchesResponseHandling(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResponse(Status status, String reason, int retryAfter, String serverHeader, FeatureTags featureTags, String contentType, String content) {
        MonitoredAddress monitoredAddress = this;
        synchronized (monitoredAddress) {
            this.reason = reason;
            this.retryAfter = retryAfter;
            this.loadFactor = this.parseLoadFactor(contentType, content);
            this.lastResponse.set(this.getTimeInMillis());
            this.responseMs.set(this.lastResponse.get() - this.sentOptions.get());
            if (status == Status.DOWN) {
                ++this.downCount;
                this.upCount = 0;
                if (this.downCount >= this.entity.getRetries()) {
                    this.setStatus(Status.DOWN);
                }
            } else if (status == Status.UP) {
                ++this.upCount;
                this.downCount = 0;
                if (this.upCount >= this.entity.getOkResponses()) {
                    this.setStatus(Status.UP);
                }
            } else {
                this.downCount = 0;
                this.upCount = 0;
                this.setStatus(status);
            }
        }
        this.entity.processResponse(serverHeader, featureTags);
    }

    protected Integer parseLoadFactor(String contentType, String content) {
        int idx2;
        int idx1;
        if (content != null && "application/com.avaya.media-server-perf-v1+xml".equals(contentType) && (idx1 = content.indexOf("<LoadFactor>")) > 0 && (idx2 = content.indexOf("</LoadFactor>", idx1 + 12)) > 0) {
            try {
                int value = Integer.parseInt(content.substring(idx1 + 12, idx2).trim());
                if (value >= 0 && value <= 100) {
                    return value;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAddressTemporarilyDown(String reason, int retryAfter) {
        MonitoredAddress monitoredAddress = this;
        synchronized (monitoredAddress) {
            this.reason = reason;
            this.retryAfter = retryAfter;
            this.lastResponse.set(this.getTimeInMillis());
            this.setStatus(Status.DOWN);
        }
        this.entity.addressWasMarkedDown();
    }

    protected long getTimeInMillis() {
        return Calendar.getInstance().getTimeInMillis();
    }

    public Status getStatus() {
        if (this.entity != null && this.entity.getTentativelyUp()) {
            return Status.UP;
        }
        return this.status;
    }

    public synchronized void setStatus(Status newStatus) {
        this.transitions.update(newStatus, this.reason, this.lastResponse.get());
        if (newStatus != this.status && this.entity != null) {
            this.entity.setWriteDeadZoneFiles(MonitoredEntity.ZoneFileStatus.MODIFYZONE);
        }
        this.status = newStatus;
    }

    public boolean denyNewService() {
        return this.denyNewService;
    }

    public void denyNewService(boolean denyNewService) {
        this.denyNewService = denyNewService;
    }

    public boolean isRefusingService() {
        return this.status == Status.DENY || this.status == Status.DOWN && this.retryAfter != 0;
    }

    public String toString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return "MonitoredAddress[" + this.getKey() + ", status=" + (Object)((Object)this.status) + ", deny=" + this.denyNewService + ", upCount=" + this.upCount + ", downCount=" + this.downCount + ", sentOptions=" + dateFormat.format(this.sentOptions) + ", lastResponse=" + dateFormat.format(this.lastResponse.get()) + ", responseMs=" + this.responseMs + ", reason=\"" + this.reason + "\", retryAfter=" + this.retryAfter + ", loadFactor=" + this.loadFactor + ", transitions=" + this.transitions + "]";
    }

    public static enum Status {
        INITIALIZING,
        UP,
        DOWN,
        DENY;

    }
}

