/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.tools;

import com.avaya.asm.datamgr.tools.SMConsoleParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class SMConsoleCommand
implements Serializable {
    private static final long serialVersionUID = -5732156171595174530L;
    private List<SMConsoleParam> paramList = new ArrayList<SMConsoleParam>();
    private String cmdName;
    private CommandType cmdType;
    private String[] cmdTokens;
    private String description;

    public SMConsoleCommand(String name) {
        this.cmdName = name == null ? "" : name;
        this.cmdType = this.cmdName.toLowerCase().startsWith("methods") || this.cmdName.toLowerCase().startsWith("define") || this.cmdName.toLowerCase().startsWith("status") ? CommandType.get(this.cmdName) : CommandType.get("other");
        this.cmdTokens = this.cmdName.toLowerCase().split(" ");
    }

    public SMConsoleCommand(String name, List<SMConsoleParam> paramList) {
        this(name);
        this.paramList = paramList;
    }

    public CommandType getCmdType() {
        return this.cmdType;
    }

    public String getCmdName() {
        return this.cmdName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getCmdNameTokens() {
        StringTokenizer st = new StringTokenizer(this.cmdName, " ");
        return st.countTokens();
    }

    public void addParam(SMConsoleParam param) {
        if (param == null) {
            return;
        }
        this.paramList.add(param);
        boolean haveOpt = false;
        for (SMConsoleParam p : this.paramList) {
            if (p.isRequired()) {
                if (!haveOpt) continue;
                throw new IllegalArgumentException("invalid optional argument order");
            }
            haveOpt = true;
        }
    }

    public void clearValues() {
        for (SMConsoleParam p : this.paramList) {
            p.setValue(null);
        }
    }

    public boolean nameMatches(String toMatch) {
        String[] wordsToMatch = toMatch.split(" ");
        for (int i = 0; i < wordsToMatch.length && i < this.cmdTokens.length; ++i) {
            if (this.cmdTokens[i].startsWith(wordsToMatch[i])) continue;
            return false;
        }
        return true;
    }

    public void makeAsDuplicateCommand(String otherDataMgrName, String curDataMgrName) {
        if (this.paramList.size() == 0) {
            SMConsoleParam param = new SMConsoleParam("DataMgr");
            param.addAllowedValue(otherDataMgrName);
            param.addAllowedValue(curDataMgrName);
            this.paramList.add(param);
        } else if (!this.paramList.get(0).isAllowedParam(otherDataMgrName)) {
            SMConsoleParam param = new SMConsoleParam("DataMgr");
            param.addAllowedValue(otherDataMgrName);
            param.addAllowedValue(curDataMgrName);
            this.paramList.add(0, param);
        } else if (this.paramList.get(0).isAllowedParam(otherDataMgrName)) {
            SMConsoleParam param = this.paramList.get(0);
            param.addAllowedValue(curDataMgrName);
            this.paramList.set(0, param);
        }
    }

    public SMConsoleParam getParam(String name) {
        if (this.paramList.size() == 0) {
            return null;
        }
        for (SMConsoleParam param : this.paramList) {
            if (!param.getParamName().equalsIgnoreCase(name)) continue;
            return param;
        }
        return null;
    }

    public int hashCode() {
        int retValue = this.cmdName.hashCode();
        for (SMConsoleParam p : this.paramList) {
            retValue += p.hashCode();
        }
        return retValue;
    }

    public boolean equals(Object o) {
        SMConsoleCommand cmd;
        if (o != null && o instanceof SMConsoleCommand && this.cmdName.equals((cmd = (SMConsoleCommand)o).getCmdName())) {
            if (this.paramList.equals(cmd.paramList)) {
                return true;
            }
            ArrayList<SMConsoleParam> paramTypeList = new ArrayList<SMConsoleParam>();
            for (SMConsoleParam p : this.paramList) {
                if (!p.isTypedParam()) continue;
                paramTypeList.add(p);
            }
            if (paramTypeList.equals(cmd.paramList)) {
                return true;
            }
        }
        return false;
    }

    public SMConsoleParam getParam(int ix) {
        return this.paramList.get(ix);
    }

    public int getParamCount() {
        return this.paramList.size();
    }

    public int getTypedParamCount() {
        int count = 0;
        for (SMConsoleParam p : this.paramList) {
            if (!p.isTypedParam()) continue;
            ++count;
        }
        return count;
    }

    public List<SMConsoleParam> getParams() {
        return this.paramList;
    }

    public int minArgs() {
        Iterator<SMConsoleParam> iter = this.paramList.iterator();
        int minArgs = 0;
        while (iter.hasNext()) {
            SMConsoleParam arg = iter.next();
            if (!arg.isRequired()) continue;
            ++minArgs;
        }
        return minArgs;
    }

    public int maxArgs() {
        int maxArgs = this.paramList.size();
        if (!this.paramList.isEmpty() && this.paramList.get(this.paramList.size() - 1).isArray()) {
            maxArgs = Integer.MAX_VALUE;
        }
        return maxArgs;
    }

    public String usage() {
        String retStr = this.toString() + " - ";
        String description = this.description;
        if (description == null || description.isEmpty()) {
            description = "No description provided";
        }
        retStr = retStr + description + "\n";
        return retStr;
    }

    public String toString() {
        StringBuilder retStr = new StringBuilder();
        boolean firstMethodParam = true;
        retStr.append(this.cmdName);
        for (SMConsoleParam param : this.paramList) {
            if (firstMethodParam) {
                retStr.append(" (");
            } else {
                retStr.append(", ");
            }
            firstMethodParam = false;
            if (!(param.isRequired() || param.getParamName() != null && param.getParamName().length() != 0)) {
                retStr.append("[params...]");
                break;
            }
            retStr.append(param.toString());
        }
        if (!firstMethodParam) {
            retStr.append(")");
        }
        return retStr.toString();
    }

    public static enum CommandType {
        DEFINE("define"),
        METHODS("methods"),
        STATUS("status"),
        OTHER("other");

        private String cmdType;

        private CommandType(String s) {
            this.cmdType = s;
        }

        public static CommandType get(String cmdType) {
            for (CommandType curCmdType : CommandType.values()) {
                if (!cmdType.toLowerCase().equalsIgnoreCase(curCmdType.cmdType)) continue;
                return curCmdType;
            }
            for (CommandType curCmdType : CommandType.values()) {
                if (!cmdType.toLowerCase().startsWith(curCmdType.cmdType)) continue;
                return curCmdType;
            }
            return OTHER;
        }
    }
}

