/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.bootstrap.util;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.DMConstants;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DMUtilities;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationListener;
import com.avaya.asm.datamgr.datadistributionlayer.DDLRetention;
import com.avaya.asm.datamgr.datadistributionlayer.DDLUsageType;
import com.avaya.asm.datamgr.datadistributionlayer.DDLUsageTypeLeader;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerFactory;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerListener;
import com.avaya.asm.datamgr.tools.SMConsoleListener;
import com.avaya.common.logging.client.Logger;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class BootstrapUtilities {
    private static Logger log = AsmLogger.getLogger(BootstrapUtilities.class);
    static DMFactory dmFactory;
    static DataDistLayerFactory ddlFactory;
    static DMConstants.ProductType productType;

    protected static DMFactory getDMFactory() {
        if (dmFactory == null) {
            dmFactory = DMFactory.getInstance();
        }
        return dmFactory;
    }

    protected static DataDistLayerFactory getDDLFactory() {
        if (ddlFactory == null) {
            ddlFactory = DataDistLayerFactory.getInstance();
        }
        return ddlFactory;
    }

    protected static DMConstants.ProductType getProductType() {
        if (productType == null) {
            productType = DMUtilities.getProductType();
        }
        return productType;
    }

    public static void runCommonBootStrap(Object registeredObj, boolean isLeader, String memberName, Properties loadRules) {
        try {
            if (loadRules == null) {
                BootstrapUtilities.getDMFactory().registerIgnoredCL(registeredObj);
            } else {
                BootstrapUtilities.getDMFactory().registerIgnoredCL(registeredObj, loadRules);
            }
            BootstrapUtilities.getDDLFactory().setupJGroupClusters(BootstrapUtilities.getUsageType(isLeader, memberName));
            DMUtilities.modifyDefaultLocalSettingsPerArchitecture();
        }
        catch (Exception e) {
            log.error((Object)"Error bootstrapping in common bootstrap code!", (Throwable)e);
        }
    }

    protected static DDLUsageType getUsageType(boolean isLeader, final String memberName) {
        log.info((Object)("Detected InstallType [" + (Object)((Object)BootstrapUtilities.getProductType()) + "]"));
        if (!isLeader) {
            return new DDLUsageType(){

                @Override
                public List<DataDistLayerListener> getUsageListeners() {
                    return Arrays.asList(BootstrapUtilities.getStandardUsageListeners());
                }

                @Override
                public String getMemberName() {
                    return memberName;
                }
            };
        }
        return new DDLUsageTypeLeader(){

            @Override
            public List<DataDistLayerListener> getUsageListeners() {
                return Arrays.asList(BootstrapUtilities.getStandardUsageListeners());
            }

            @Override
            public List<DDLRetention> getRetentionRules() {
                return null;
            }

            @Override
            public List<DataDistLayerListener> getInterClusterUsageListeners() {
                return null;
            }

            @Override
            public String getMemberName() {
                return memberName;
            }
        };
    }

    protected static DataDistLayerListener[] getStandardUsageListeners() {
        return new DataDistLayerListener[]{DAOReplicationListener.getInstance(), SMConsoleListener.getInstance()};
    }
}

