/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.commons.lang;

import com.avaya.commons.lang.ArgAssert;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnicodeByteOrderMark {
    public static final String STRING = "\ufeff";

    private UnicodeByteOrderMark() {
    }

    public static byte[] getBytes(Charset charset) {
        ArgAssert.assertNotNull(charset, "charset");
        try {
            return STRING.getBytes(charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    static int getMaxNumBytes(Set<Charset> charsets) {
        int max = 0;
        for (Charset charset : charsets) {
            max = Math.max(max, UnicodeByteOrderMark.getBytes(charset).length);
        }
        return max;
    }
}

