/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DMListener;
import com.avaya.asm.datamgr.DMUtilities;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.InstanceDAO;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.Instance;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.AusInstance;
import com.avaya.zephyr.platform.dm.PlatformServiceDM;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class AusInstanceDAO
extends InstanceDAO {
    protected static final Logger LOG = AsmLogger.getLogger(AusInstanceDAO.class);
    protected static final String ZR_INSTANCE_TABLE = "zr_fsinstance";
    protected static final String ID = "id";
    protected static final String ASSET_ID = "asset_id";
    protected static final String SIPENTITY_ID = "sipentity_id";
    protected static final String MGMT_HOST_NAME = "managementaccesspointhostname";
    protected static final String DESCRIPTION = "description";
    protected static final String IS_MONITORING = "is_monitoring";
    protected static final String MONITOR_PRO_SECS = "monitor_proactive_secs";
    protected static final String MONITOR_REA_SECS = "monitor_reactive_secs";
    protected static final String MONITOR_RETRIES = "monitor_retries";
    protected static final String CLUSTER_ID = "cluster_id";
    protected static final String ADMINED_TO_DENY_NEW_SERVICE = "admined_to_deny_new_service";
    protected static final String LU_ORDER = "lu_order";
    protected static final String LB_ORDER = "lb_order";
    protected static final String UCID_NODE = "ucid_node";
    protected static final String HADB_ROLE = "hadb_role";
    protected static final String MGMT_HOST_NAME_IPV6 = "managementaccesspointhostname_ipv6";
    protected static final String GET_INSTANCES = "SELECT id, description, managementaccesspointhostname, is_monitoring, monitor_proactive_secs, monitor_reactive_secs, monitor_retries, asset_id, sipentity_id, cluster_id, admined_to_deny_new_service ,lu_order, lb_order, ucid_node, hadb_role, managementaccesspointhostname_ipv6 FROM zr_fsinstance";
    protected static final String GET_INSTANCE = "SELECT id, description, managementaccesspointhostname, is_monitoring, monitor_proactive_secs, monitor_reactive_secs, monitor_retries, asset_id, sipentity_id, cluster_id, admined_to_deny_new_service ,lu_order, lb_order, ucid_node, hadb_role, managementaccesspointhostname_ipv6 FROM zr_fsinstance WHERE id = ?";
    protected static final String GET_AUS_INSTANCE_BY_ID = "SELECT id, description, managementaccesspointhostname, is_monitoring, monitor_proactive_secs, monitor_reactive_secs, monitor_retries, asset_id, sipentity_id, cluster_id, admined_to_deny_new_service ,lu_order, lb_order, ucid_node, hadb_role, managementaccesspointhostname_ipv6 FROM zr_fsinstance WHERE id = ?";
    private Map<Long, Instance> ausInstanceMap;
    private Map<Long, Map<String, AusInstance>> clusterIDToAusInstanceMap;
    private Long cachedClusterId = null;
    private static final List<DMListener> LISTENERS = new CopyOnWriteArrayList<DMListener>();
    protected static final ResultSetMapper instanceMapper = new GetResultSetMapper();

    public Map<Long, Map<String, AusInstance>> getClusterIDToAusInstanceMap() {
        return this.clusterIDToAusInstanceMap;
    }

    public Map<Long, Instance> getAusInstanceMap() {
        return this.ausInstanceMap;
    }

    public Long getCachedClusterId() {
        return this.cachedClusterId;
    }

    protected String getInstancesQuery() {
        return GET_INSTANCES;
    }

    protected String getInstanceQuery() {
        return "SELECT id, description, managementaccesspointhostname, is_monitoring, monitor_proactive_secs, monitor_reactive_secs, monitor_retries, asset_id, sipentity_id, cluster_id, admined_to_deny_new_service ,lu_order, lb_order, ucid_node, hadb_role, managementaccesspointhostname_ipv6 FROM zr_fsinstance WHERE id = ?";
    }

    protected ResultSetMapper getMapper() {
        return instanceMapper;
    }

    protected boolean tryResolveIdentity() {
        return DMUtilities.isAusInstance();
    }

    public void init() {
        this.clusterIDToAusInstanceMap = new ConcurrentHashMap<Long, Map<String, AusInstance>>();
        this.ausInstanceMap = new ConcurrentHashMap<Long, Instance>();
        super.init();
        this.lock.acquireWriteLock();
        try {
            this.ausInstanceMap.putAll(this.getAllInstances());
        }
        finally {
            this.lock.releaseWriteLock();
        }
        Map<Long, Map<String, AusInstance>> tmpClusterIDToAusInstanceMap = this.loadClusterIDToAusInstanceMap();
        this.lock.acquireWriteLock();
        try {
            this.clusterIDToAusInstanceMap = tmpClusterIDToAusInstanceMap;
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    public void registerListener(DMListener listener) {
        if (!LISTENERS.contains(listener)) {
            LISTENERS.add(listener);
        } else if (listener instanceof DataMgr) {
            for (DMListener l : LISTENERS) {
                if (!l.equals(listener) || l.equals(listener)) continue;
                log.finer((Object)("registerListener: We are replacing this listener with a new version: " + listener.getClass().getSimpleName() + " for " + ((Object)((Object)this)).getClass().getSimpleName()));
                LISTENERS.remove(l);
                LISTENERS.add(listener);
            }
        }
    }

    public void removeListener(DMListener listener) {
        LISTENERS.remove(listener);
    }

    protected final void updateListeners(Object oldObj, Object newObj) {
        for (DMListener listener : LISTENERS) {
            try {
                listener.objectChanged(oldObj, newObj);
            }
            catch (Exception e) {
                log.error((Object)("Exception on invoking objectChanged on " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                log.error((Object)"Exception is: ", (Throwable)e);
            }
            catch (NoClassDefFoundError e) {
                LOG.error((Object)("updateListeners NoClassDefFoundError on invoking objectChanged on " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                LOG.error((Object)"updateListeners Error is: ", (Throwable)e);
                LOG.error((Object)("updateListeners Unregistering the listener " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                this.removeListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Long, Map<String, AusInstance>> loadClusterIDToAusInstanceMap() {
        ConcurrentHashMap<Long, Map<String, AusInstance>> tmpClusterIDToAusInstanceMap = new ConcurrentHashMap<Long, Map<String, AusInstance>>();
        AusInstance ausInst = null;
        Long clusterId = null;
        this.lock.acquireReadLock();
        try {
            if (!this.ausInstanceMap.isEmpty()) {
                for (Map.Entry<Long, Instance> instance : this.ausInstanceMap.entrySet()) {
                    ausInst = (AusInstance)instance.getValue();
                    clusterId = ausInst.getCluster_id();
                    if (tmpClusterIDToAusInstanceMap.get(clusterId) == null) {
                        tmpClusterIDToAusInstanceMap.put(clusterId, new ConcurrentHashMap());
                    }
                    ((Map)tmpClusterIDToAusInstanceMap.get(clusterId)).put(ausInst.getManagementAccessPointHostName(), ausInst);
                }
                ConcurrentHashMap<Long, Map<String, AusInstance>> concurrentHashMap = tmpClusterIDToAusInstanceMap;
                return concurrentHashMap;
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return tmpClusterIDToAusInstanceMap;
    }

    public void updateDAO(DAOTableEvent tableEvent) {
        String tableName = tableEvent.getTableName();
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        super.updateDAO(tableEvent);
        if (tableName.equals(ZR_INSTANCE_TABLE) && operation != null) {
            if (operation.equals((Object)DAOReplicationEvent.OperationType.INSERT)) {
                this.insertClusterIDToAusInstanceMap(tableEvent.getKey());
            } else if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE)) {
                this.deleteFromClusterIDToAusInstanceMap(tableEvent.getKey());
                this.updateClusterIDToAusInstanceMap(tableEvent.getKey());
            } else {
                this.deleteFromClusterIDToAusInstanceMap(tableEvent.getKey());
            }
        }
    }

    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ZR_INSTANCE_TABLE);
        return list;
    }

    protected void insertClusterIDToAusInstanceMap(Long id) {
        block6: {
            try {
                AusInstance newInstance = (AusInstance)((Object)this.getAllInstances().get(id));
                if (newInstance == null) break block6;
                try {
                    this.lock.acquireWriteLock();
                    this.ausInstanceMap.put(id, newInstance);
                    if (this.clusterIDToAusInstanceMap.get(newInstance.getCluster_id()) == null) {
                        this.clusterIDToAusInstanceMap.put(newInstance.getCluster_id(), new ConcurrentHashMap());
                    }
                    this.clusterIDToAusInstanceMap.get(newInstance.getCluster_id()).put(newInstance.getManagementAccessPointHostName(), newInstance);
                }
                finally {
                    this.lock.releaseWriteLock();
                }
            }
            catch (Exception exception) {
                LOG.error((Object)("Error while updating cache for change in table zr_fsinstance For id=" + id + "Exception:" + exception.getMessage()));
                this.reinit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateClusterIDToAusInstanceMap(Long id) {
        block6: {
            try {
                AusInstance oldInstance = null;
                AusInstance newInstance = (AusInstance)((Object)this.getAllInstances().get(id));
                if (newInstance == null) break block6;
                Long clusterId = newInstance.getCluster_id();
                try {
                    this.lock.acquireWriteLock();
                    oldInstance = (AusInstance)this.ausInstanceMap.get(id);
                    this.ausInstanceMap.put(id, newInstance);
                    if (this.clusterIDToAusInstanceMap.get(clusterId) == null) {
                        this.clusterIDToAusInstanceMap.put(clusterId, new ConcurrentHashMap());
                    }
                    this.clusterIDToAusInstanceMap.get(clusterId).put(newInstance.getManagementAccessPointHostName(), newInstance);
                }
                finally {
                    this.lock.releaseWriteLock();
                }
                this.updateListeners((Object)oldInstance, (Object)newInstance);
            }
            catch (Exception exception) {
                LOG.error((Object)("Error while updating cache for change in table zr_fsinstance For id=" + id + "Exception:" + exception.getMessage()));
                this.reinit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteFromClusterIDToAusInstanceMap(Long id) {
        AusInstance oldInstance = null;
        String hostName = null;
        Long clusterId = null;
        try {
            try {
                this.lock.acquireWriteLock();
                oldInstance = (AusInstance)this.ausInstanceMap.get(id);
                this.ausInstanceMap.remove(id);
                clusterId = oldInstance.getCluster_id();
                hostName = oldInstance.getManagementAccessPointHostName();
                if (clusterId != null) {
                    this.clusterIDToAusInstanceMap.get(clusterId).remove(hostName);
                    if (this.clusterIDToAusInstanceMap.get(clusterId).isEmpty()) {
                        this.clusterIDToAusInstanceMap.remove(clusterId);
                    }
                }
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
        catch (Exception exception) {
            LOG.error((Object)("Error while updating cache for change in table zr_fsinstance For id=" + id + "Exception:" + exception.getMessage()));
            this.reinit();
        }
    }

    protected DMFactory getDMFactory() {
        return DMFactory.getInstance();
    }

    @SMConsole(description="Get the AusInstance object for this EDP instance.")
    public AusInstance getMyAusInstance() {
        return (AusInstance)this.getMyInstance();
    }

    @SMConsole(parameterNames={"ausInstanceId"}, description="Get the AusInstance object for the given ID.")
    public AusInstance getAusInstance(Long ausInstanceId) {
        return (AusInstance)this.getInstance(ausInstanceId);
    }

    @SMConsole(description="Get all provisioned Session Manager instances.")
    public Map<Long, Instance> getAllAusInstances() {
        return this.getAllInstances();
    }

    @SMConsole(description="Get all provisioned Session Manager entities.")
    public Map<Long, Instance> getAllAsmEntities() {
        return this.getAllInstanceEntities();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(description="Get all AusInstances for this cluster.")
    public List<String> getAusInstances() {
        ArrayList<String> instances = new ArrayList<String>();
        Long clusterId = this.getMyClusterId();
        if (clusterId != null && !clusterId.equals(0L)) {
            try {
                this.lock.acquireReadLock();
                Map<String, AusInstance> ausInstances = this.clusterIDToAusInstanceMap.get(clusterId);
                instances.addAll(ausInstances.keySet());
            }
            catch (Exception e) {
                LOG.error((Object)"getAusInstances Unable to obtain AusInstance data.   Exception: ", (Throwable)e);
            }
            finally {
                this.lock.releaseReadLock();
            }
        } else {
            LOG.warn((Object)"getAusInstances got a null cluster ID for server; may not belong to a cluster yet. Check SMGR provisioning.");
        }
        return instances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(description="Get all AusInstances for the cluster with given cluster Id.")
    public List<String> getAusInstances(Long clusterId) {
        ArrayList<String> instances = new ArrayList<String>();
        if (clusterId != null && !clusterId.equals(0L)) {
            try {
                this.lock.acquireReadLock();
                Map<String, AusInstance> ausInstances = this.clusterIDToAusInstanceMap.get(clusterId);
                if (ausInstances != null) {
                    instances.addAll(ausInstances.keySet());
                }
            }
            catch (Exception e) {
                LOG.error((Object)"getAusInstances Unable to obtain AusInstance data.   Exception: ", (Throwable)e);
            }
            finally {
                this.lock.releaseReadLock();
            }
        }
        return instances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(description="Returns the clusterId of this EDP instance")
    public Long getMyClusterId() {
        Long tmpClusterId = null;
        DMFactory dmFactory = this.getDMFactory();
        PlatformServiceDM dm = (PlatformServiceDM)dmFactory.getDataMgr(PlatformServiceDM.class);
        String myInstaceIP = dm.getMyInstanceIP();
        if (myInstaceIP == null) {
            LOG.warn((Object)"getMyClusterId management IP is null, cannot retrieve the cluster ID; check Replication status");
            return null;
        }
        try {
            this.lock.acquireReadLock();
            if (this.cachedClusterId != null && this.clusterIDToAusInstanceMap.get(this.cachedClusterId) != null && this.clusterIDToAusInstanceMap.get(this.cachedClusterId).keySet().contains(myInstaceIP)) {
                Long l = this.cachedClusterId;
                return l;
            }
            for (Map.Entry<Long, Map<String, AusInstance>> instance : this.clusterIDToAusInstanceMap.entrySet()) {
                if (!instance.getValue().keySet().contains(myInstaceIP)) continue;
                tmpClusterId = instance.getKey();
                break;
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        try {
            this.lock.acquireWriteLock();
            this.cachedClusterId = tmpClusterId;
        }
        finally {
            this.lock.releaseWriteLock();
        }
        return this.cachedClusterId;
    }

    @SMConsole(description="Returns the admined_to_deny_new_service flag of current EDP instance")
    public final boolean getAdminedToDenyNewServiceFlag() {
        return this.getMyAusInstance().getAdmined_to_deny_new_service();
    }

    @SMConsole(description="Returns the UCID Network Node ID of current EDP instance")
    public final short getMyNetworkNodeId() {
        return this.getMyAusInstance().getUcid_node();
    }

    @SMConsole(description="Returns an AusInstance list with LUS. First entry being Primary and then secondary.")
    public ArrayList<AusInstance> getLookUpService() {
        Long clusterId = this.getMyClusterId();
        ArrayList<AusInstance> instanceList = this.getLookUpService(clusterId);
        return instanceList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(description="Returns an AusInstance list with LUS, For a given cluster Id. First entry being Primary and then secondary.")
    public ArrayList<AusInstance> getLookUpService(Long clusterId) {
        ArrayList<AusInstance> instanceList = new ArrayList<AusInstance>();
        try {
            this.lock.acquireReadLock();
            Map<String, AusInstance> ausInstances = this.clusterIDToAusInstanceMap.get(clusterId);
            if (ausInstances == null || ausInstances.size() == 0) {
                ArrayList<AusInstance> arrayList = instanceList;
                return arrayList;
            }
            for (Map.Entry<String, AusInstance> instance : ausInstances.entrySet()) {
                AusInstance ausInst = instance.getValue();
                if (instanceList.size() >= 3) continue;
                if (ausInst.getLu_order() == 1) {
                    instanceList.add(0, ausInst);
                    continue;
                }
                if (ausInst.getLu_order() == 2) {
                    instanceList.add(ausInst);
                    continue;
                }
                if (ausInst.getLu_order() != 3) continue;
                instanceList.add(ausInst);
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return instanceList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(description="Returns an AusInstance list with Load Balancer.First entry being Primary and then secondary.")
    public ArrayList<AusInstance> getLoadBalancer() {
        ArrayList<AusInstance> instanceList = new ArrayList<AusInstance>();
        Long clusterId = this.getMyClusterId();
        try {
            this.lock.acquireReadLock();
            Map<String, AusInstance> ausInstances = this.clusterIDToAusInstanceMap.get(clusterId);
            for (Map.Entry<String, AusInstance> instance : ausInstances.entrySet()) {
                AusInstance ausInst = instance.getValue();
                if (instanceList.size() >= 2) continue;
                if (ausInst.getLb_order() == 1) {
                    instanceList.add(0, ausInst);
                    continue;
                }
                if (ausInst.getLb_order() != 2) continue;
                instanceList.add(ausInst);
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return instanceList;
    }

    protected static class GetResultSetMapper
    implements ResultSetMapper {
        protected GetResultSetMapper() {
        }

        public Object mapResults(ResultSet rs) throws SQLException {
            ConcurrentHashMap<Long, AusInstance> map = new ConcurrentHashMap<Long, AusInstance>();
            while (rs.next()) {
                map.put(rs.getLong(AusInstanceDAO.ID), new AusInstance(rs.getLong(AusInstanceDAO.ID), rs.getLong(AusInstanceDAO.SIPENTITY_ID), rs.getLong(AusInstanceDAO.ASSET_ID), rs.getString(AusInstanceDAO.MGMT_HOST_NAME), rs.getString(AusInstanceDAO.DESCRIPTION), rs.getBoolean(AusInstanceDAO.IS_MONITORING), rs.getInt(AusInstanceDAO.MONITOR_PRO_SECS), rs.getInt(AusInstanceDAO.MONITOR_REA_SECS), rs.getInt(AusInstanceDAO.MONITOR_RETRIES), rs.getLong(AusInstanceDAO.CLUSTER_ID), rs.getBoolean(AusInstanceDAO.ADMINED_TO_DENY_NEW_SERVICE), rs.getInt(AusInstanceDAO.LU_ORDER), rs.getInt(AusInstanceDAO.LB_ORDER), rs.getShort(AusInstanceDAO.UCID_NODE), rs.getString(AusInstanceDAO.HADB_ROLE), rs.getString(AusInstanceDAO.MGMT_HOST_NAME_IPV6)));
            }
            return map;
        }
    }
}

