/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.eclipse.plugin.model;

import com.avaya.eclipse.plugin.Activator;
import com.avaya.eclipse.plugin.PropertyWindowEditor;
import com.avaya.eclipse.plugin.ServerTreeView;
import com.avaya.eclipse.plugin.model.ElementInfo;
import com.avaya.eclipse.plugin.operation.CEOperation;
import com.avaya.ssh.SSHConnection;
import com.avaya.ssh.SSHConnector;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TreeLoader {
    private static TreeLoader instance;
    private ServerTreeView.Node rootNode;
    private static String stateLocation;
    private String scriptPath = "/opt/Avaya/AUS/install/";
    private boolean isUpdated = false;
    private boolean isConnectionCheckRequired = false;
    private Map<String, ElementInfo> elementGlobalMap = new HashMap<String, ElementInfo>();

    public static String getStateLocation() {
        return stateLocation;
    }

    public static void setStateLocation(String stateLocation) {
        TreeLoader.stateLocation = stateLocation;
    }

    public Map<String, ElementInfo> getElementGlobalMap() {
        return this.elementGlobalMap;
    }

    public static TreeLoader getInstance() {
        if (instance == null) {
            instance = new TreeLoader();
        }
        return instance;
    }

    private TreeLoader() {
        if (Activator.getDefault() != null) {
            stateLocation = Activator.getDefault().getStateLocation().toFile().getAbsolutePath();
        }
        this.load();
    }

    public boolean isUpdated() {
        return this.isUpdated;
    }

    public boolean isConnectionCheckRequired() {
        return this.isConnectionCheckRequired;
    }

    public void setConnectionCheckRequired() {
        this.isConnectionCheckRequired = true;
    }

    public void resetConnectionCheckRequired() {
        this.isConnectionCheckRequired = false;
    }

    private void resetUpdates() {
        this.isUpdated = false;
    }

    public void setUpdated() {
        this.isUpdated = true;
    }

    public List<ServerTreeView.Node> getSelectedNodes() {
        ArrayList<ServerTreeView.Node> nList = new ArrayList<ServerTreeView.Node>();
        this.fillSelectedChidren(this.rootNode, nList, true);
        return nList;
    }

    public List<ServerTreeView.Node> getGrayedNodes() {
        ArrayList<ServerTreeView.Node> nList = new ArrayList<ServerTreeView.Node>();
        this.fillSelectedChidren(this.rootNode, nList, false);
        return nList;
    }

    public List<ElementInfo> getSelectedElements() {
        ArrayList<ElementInfo> nList = new ArrayList<ElementInfo>();
        this.fillSelectedElements(this.rootNode, nList);
        return nList;
    }

    public List<ElementInfo> getAllElements() {
        ArrayList<ElementInfo> nList = new ArrayList<ElementInfo>();
        this.fillElements(this.rootNode, nList);
        return nList;
    }

    public List<ElementInfo> getSelectedNodesAsElement() {
        ArrayList<ElementInfo> nList = new ArrayList<ElementInfo>();
        this.fillSelectedChidrenAsElements(this.rootNode, nList, null, true);
        return nList;
    }

    private void fillSelectedChidrenAsElements(ServerTreeView.Node n, List<ElementInfo> nList, ElementInfo elem, boolean isSelected) {
        for (ServerTreeView.Node n1 : n.getChildren()) {
            if (isSelected) {
                if (n1.getElementInfo().isGrayed() || n1.getElementInfo().isChecked()) {
                    if (elem == null) {
                        nList.add(n1.getElementInfo());
                    } else {
                        elem.addAssociatedElement(n1.getElementInfo());
                    }
                }
            } else if (n1.getElementInfo().isGrayed()) {
                if (elem == null) {
                    nList.add(n1.getElementInfo());
                } else {
                    elem.addAssociatedElement(n1.getElementInfo());
                }
            }
            if (!n1.hasChildren()) continue;
            this.fillSelectedChidrenAsElements(n1, nList, n1.getElementInfo(), isSelected);
        }
    }

    private void fillSelectedChidren(ServerTreeView.Node n, List<ServerTreeView.Node> nList, boolean isSelected) {
        for (ServerTreeView.Node n1 : n.getChildren()) {
            if (isSelected) {
                if (n1.getElementInfo().isGrayed() || n1.getElementInfo().isChecked()) {
                    nList.add(n1);
                }
            } else if (n1.getElementInfo().isGrayed()) {
                nList.add(n1);
            }
            if (!n1.hasChildren()) continue;
            this.fillSelectedChidren(n1, nList, isSelected);
        }
    }

    private void fillSelectedElements(ServerTreeView.Node n, List<ElementInfo> nList) {
        for (ServerTreeView.Node n1 : n.getChildren()) {
            if (n1.getElementInfo().isChecked()) {
                nList.add(n1.getElementInfo());
            }
            if (!n1.hasChildren()) continue;
            this.fillSelectedElements(n1, nList);
        }
    }

    private void fillElements(ServerTreeView.Node n, List<ElementInfo> nList) {
        for (ServerTreeView.Node n1 : n.getChildren()) {
            nList.add(n1.getElementInfo());
            if (!n1.hasChildren()) continue;
            this.fillSelectedElements(n1, nList);
        }
    }

    public ServerTreeView.Node getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(ServerTreeView.Node rootNode) {
        this.rootNode = rootNode;
    }

    public void load() {
        try {
            this.rootNode = new ServerTreeView.Node("root");
            Activator.log(1, "rootNode in load() " + this.rootNode);
            File history = new File(stateLocation, "history.xml");
            Activator.log(1, "history path in load() " + history.getAbsolutePath());
            if (!history.exists()) {
                return;
            }
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(history);
            Element root = doc.getDocumentElement();
            if (root.hasChildNodes()) {
                NodeList smgrs = root.getChildNodes();
                for (int i = 0; i < smgrs.getLength(); ++i) {
                    this.rootNode.addChild(this.loadElement((Element)smgrs.item(i)));
                }
            }
            this.resetUpdates();
            this.resetConnectionCheckRequired();
            PropertyWindowEditor.createRSESystem(this.getAllElements());
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error during load", e);
        }
    }

    public void save(List<Object> checkedElements, List<Object> grayedElements) {
        if (!this.isUpdated()) {
            Activator.log(1, "Nothing to Save..");
            return;
        }
        try {
            SSHConnector.getInstance().disconnectAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        File history = new File(stateLocation, "history.xml");
        Activator.log(1, "history path in save() " + history.getAbsolutePath());
        HashMap<Integer, Object> nodeMap = null;
        HashMap<Integer, Object> grayedMap = null;
        if (checkedElements != null) {
            nodeMap = new HashMap<Integer, Object>();
            for (Object ob : checkedElements) {
                nodeMap.put(ob.hashCode(), ob);
            }
        }
        if (grayedElements != null) {
            grayedMap = new HashMap<Integer, Object>();
            for (Object ob : grayedElements) {
                grayedMap.put(ob.hashCode(), ob);
            }
        }
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            Element root = doc.createElement("history");
            doc.appendChild(root);
            this.saveNode(this.rootNode, doc, root, nodeMap, grayedMap);
            Activator.log(1, "history rootNode in save() " + this.rootNode);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult target = new StreamResult(history);
            transformer.transform(source, target);
            Activator.log(1, "Updated ...");
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error during save", e);
        }
    }

    public void discoverNodes() {
    }

    private void saveNode(ServerTreeView.Node node, Document doc, Node nodeToAppend, Map<Integer, Object> nodeMap, Map<Integer, Object> grayMap) {
        if (node != null) {
            ElementInfo ei = node.getElementInfo();
            Node cnodeToAppend = nodeToAppend;
            if (ei != null) {
                Element element = null;
                if (ei.getServerType().equals((Object)ElementInfo.ServerType.SMGR)) {
                    element = doc.createElement("smgr");
                } else if (ei.getServerType().equals((Object)ElementInfo.ServerType.CLUSTER)) {
                    element = doc.createElement("cluster");
                } else if (ei.getServerType().equals((Object)ElementInfo.ServerType.CE)) {
                    element = doc.createElement("ce");
                }
                if (nodeMap != null) {
                    if (nodeMap.containsKey(node.hashCode())) {
                        ei.setChecked(true);
                    } else {
                        ei.setChecked(false);
                    }
                }
                if (grayMap != null) {
                    if (grayMap.containsKey(node.hashCode())) {
                        ei.setGrayed(true);
                    } else {
                        ei.setGrayed(false);
                    }
                }
                if (ei.getServerType().equals((Object)ElementInfo.ServerType.CE)) {
                    if (this.isConnectionCheckRequired()) {
                        ei.setValidated(false);
                        try {
                            SSHConnection sshc = SSHConnector.getInstance().getSSHConnection(ei);
                            if (sshc.isConnected()) {
                                sshc.disconnect();
                                ei.setValidated(true);
                            }
                        }
                        catch (Exception e) {
                            Activator.log(4, 0, "Error saving node", e);
                        }
                    } else {
                        Activator.log(1, "No SSH connection check required");
                        ei.setValidated(true);
                    }
                }
                if (element != null) {
                    ei.save(element);
                }
                nodeToAppend.appendChild(element);
                cnodeToAppend = element;
            }
            if (node.getChildren() != null && !node.getChildren().isEmpty()) {
                for (ServerTreeView.Node chN : node.getChildren()) {
                    this.saveNode(chN, doc, cnodeToAppend, nodeMap, grayMap);
                }
            }
        }
    }

    private ServerTreeView.Node loadElement(Element element) throws Exception {
        ElementInfo ei = ElementInfo.load(element);
        if (!ei.getServerType().equals((Object)ElementInfo.ServerType.CLUSTER)) {
            this.elementGlobalMap.put(ei.getIp(), ei);
        }
        ServerTreeView.Node treeNode = null;
        treeNode = ei.getServerType().equals((Object)ElementInfo.ServerType.CLUSTER) ? new ServerTreeView.Node(ei.getName()) : new ServerTreeView.Node(ei.getIp());
        treeNode.setElementInfo(ei);
        if (element.hasChildNodes()) {
            NodeList children = element.getChildNodes();
            ArrayList<ServerTreeView.Node> childTreeNodes = new ArrayList<ServerTreeView.Node>();
            for (int i = 0; i < children.getLength(); ++i) {
                Element child = (Element)children.item(i);
                ServerTreeView.Node childNode = this.loadElement(child);
                childNode.setParent(treeNode);
                childTreeNodes.add(childNode);
            }
            treeNode.getChildren().addAll(childTreeNodes);
        }
        return treeNode;
    }

    public void save() {
        this.save(null, null);
    }

    public void addNewNode(ElementInfo element) {
        this.setUpdated();
        this.setConnectionCheckRequired();
        ServerTreeView.Node n = new ServerTreeView.Node(element.getServerType().name());
        n.setElementInfo(element);
        this.refreshNode(n);
    }

    public void editNode(ElementInfo ei) {
        this.setUpdated();
        this.setConnectionCheckRequired();
        this.editNode(ei, this.rootNode);
    }

    private ServerTreeView.Node getNode(ElementInfo ei, ServerTreeView.Node start) {
        ServerTreeView.Node n1;
        ServerTreeView.Node retNode = null;
        for (ServerTreeView.Node n : start.getChildren()) {
            if (!n.getElementInfo().getServerType().equals((Object)ei.getServerType()) || !n.getElementInfo().getIp().equals(ei.getIp())) continue;
            retNode = n;
            return retNode;
        }
        Iterator<ServerTreeView.Node> iterator = start.getChildren().iterator();
        while (iterator.hasNext() && (retNode = this.getNodeByOldIP(ei, n1 = iterator.next())) == null) {
        }
        return retNode;
    }

    private ServerTreeView.Node getNodeByOldIP(ElementInfo ei, ServerTreeView.Node start) {
        ServerTreeView.Node n1;
        ServerTreeView.Node retNode = null;
        for (ServerTreeView.Node n : start.getChildren()) {
            if (!n.getElementInfo().getServerType().equals((Object)ei.getServerType()) || !n.getElementInfo().getIp().equals(ei.getIp()) && !n.getElementInfo().getIp().equals(ei.getOldIp())) continue;
            retNode = n;
            return retNode;
        }
        Iterator<ServerTreeView.Node> iterator = start.getChildren().iterator();
        while (iterator.hasNext() && (retNode = this.getNode(ei, n1 = iterator.next())) == null) {
        }
        return retNode;
    }

    public void editNode(ElementInfo ei, ServerTreeView.Node startNode) {
        ServerTreeView.Node nodeToEdit = this.getNode(ei, startNode);
        if (nodeToEdit == null) {
            nodeToEdit = this.getNodeByOldIP(ei, startNode);
        }
        if (nodeToEdit != null) {
            nodeToEdit.getElementInfo().setIp(ei.getIp());
            nodeToEdit.getElementInfo().setUserName(ei.getUserName());
            nodeToEdit.getElementInfo().setPassword(ei.getPassword());
            nodeToEdit.getElementInfo().setPort(ei.getPort());
            if (ElementInfo.ServerType.CE.equals((Object)nodeToEdit.getElementInfo().getServerType())) {
                nodeToEdit.getParent().getChildren().remove(nodeToEdit);
                this.refreshNode(nodeToEdit, nodeToEdit.getParent());
            } else {
                this.rootNode.getChildren().remove(nodeToEdit);
                this.refreshNode(nodeToEdit, this.rootNode);
            }
        }
    }

    private void refreshNode(ServerTreeView.Node n) {
        this.refreshNode(n, this.rootNode);
    }

    private void refreshNode(ServerTreeView.Node n, ServerTreeView.Node startNode) {
        ServerTreeView.Node smgrNode = null;
        if (n != null) {
            if (ElementInfo.ServerType.SMGR.equals((Object)n.getElementInfo().getServerType())) {
                smgrNode = this.discoverAssociations(n);
            }
            if (smgrNode != null) {
                startNode.addChild(smgrNode);
            } else {
                startNode.addChild(n);
            }
        }
        this.save();
        this.load();
    }

    private void refreshSelectedNode(ServerTreeView.Node n, ServerTreeView.Node startNode) {
        ServerTreeView.Node smgrNode = null;
        if (n != null) {
            if (ElementInfo.ServerType.SMGR.equals((Object)n.getElementInfo().getServerType())) {
                smgrNode = this.discoverAssociations(n);
            }
            if (smgrNode != null) {
                startNode.addChild(smgrNode);
            } else {
                startNode.addChild(n);
            }
        }
        this.resetConnectionCheckRequired();
        this.save();
        this.load();
    }

    public void reomveFromRoot(ElementInfo ei) {
        this.setUpdated();
        for (int i = 0; i < this.rootNode.getChildren().size(); ++i) {
            ServerTreeView.Node n = this.rootNode.getChildren().get(i);
            if (!n.getElementInfo().getIp().equals(ei.getIp())) continue;
            this.rootNode.getChildren().remove(n);
        }
        this.save();
        this.load();
    }

    private ServerTreeView.Node discoverAssociations(ServerTreeView.Node smgrNode) {
        if (!this.isConnectionCheckRequired()) {
            Activator.log(1, "No SSH connection check required");
            ElementInfo smgr = smgrNode.getElementInfo();
            smgr.setValidated(true);
            return smgrNode;
        }
        try {
            ElementInfo smgr = smgrNode.getElementInfo();
            SSHConnection conn = SSHConnector.getInstance().getSSHConnection(smgr);
            if (!conn.isConnected()) {
                smgr.setValidated(false);
                CEOperation.openErrorDialog("Operation Failure", "Unable to connect with System Manager.Please verify that credentials configured  for System Manager is correct. ");
                return smgrNode;
            }
            smgr.setValidated(true);
            String clusters = conn.execute("sudo " + this.scriptPath + "eclipse_helper.sh -l");
            smgrNode.getChildren().clear();
            for (String line : clusters.split("\n")) {
                if (line.trim().length() == 0 || line.contains("could not change directory")) continue;
                ElementInfo clusterElement = ElementInfo.createCluster(line.trim(), smgr.getIp());
                smgr.addAssociatedElement(clusterElement);
                ServerTreeView.Node n1 = new ServerTreeView.Node("cluster");
                n1.setElementInfo(clusterElement);
                smgrNode.addChild(n1);
                String instances = conn.execute("sudo " + this.scriptPath + "eclipse_helper.sh -c \"" + clusterElement.getName() + "\"");
                for (String line1 : instances.split("\n")) {
                    try {
                        if (line1.trim().length() == 0 || line1.contains("could not change directory")) continue;
                        String[] details = line1.trim().split("\\|");
                        ElementInfo ceInfo = ElementInfo.createCE(details[0].trim(), details[1].trim());
                        ServerTreeView.Node n2 = new ServerTreeView.Node("ce");
                        n2.setElementInfo(ceInfo);
                        if (TreeLoader.getInstance().getElementGlobalMap().containsKey(ceInfo.getIp())) {
                            ceInfo.setPassword(TreeLoader.getInstance().getElementGlobalMap().get(ceInfo.getIp()).getPassword());
                        }
                        n1.addChild(n2);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error discovering associations", e);
        }
        return smgrNode;
    }

    public boolean isConnected(ElementInfo ei) {
        return false;
    }

    static void setInstance(TreeLoader treeLoader) {
        instance = treeLoader;
    }

    public void refreshNode(ElementInfo ei) {
        ServerTreeView.Node nodeToReferesh = this.getNode(ei, this.rootNode);
        if (nodeToReferesh != null) {
            nodeToReferesh.getElementInfo().setUserName(ei.getUserName());
            nodeToReferesh.getElementInfo().setPassword(ei.getPassword());
            nodeToReferesh.getElementInfo().setPort(ei.getPort());
            this.setUpdated();
            this.setConnectionCheckRequired();
            if (ElementInfo.ServerType.CE.equals((Object)nodeToReferesh.getElementInfo().getServerType())) {
                nodeToReferesh.getParent().getChildren().remove(nodeToReferesh);
                this.refreshSelectedNode(nodeToReferesh, nodeToReferesh.getParent());
            } else {
                this.rootNode.getChildren().remove(nodeToReferesh);
                this.refreshSelectedNode(nodeToReferesh, this.rootNode);
            }
            this.resetUpdates();
            this.resetConnectionCheckRequired();
        }
    }

    static {
        stateLocation = ".";
    }
}

