/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.common.logging.client;

import com.avaya.common.logging.helper.LogRecordJDO;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.jdbc.JDBCAppender;
import org.apache.log4j.spi.LoggingEvent;

public class DBAppender
extends JDBCAppender {
    private static final String POSTGRES = "POSTGRES";
    private static final String ORACLE = "ORACLE";
    private static final String DATABASE_TYPE = "databaseType";

    protected String getLogStatement(LoggingEvent loggingEvent) {
        LogRecordJDO logRecordJDO = new LogRecordJDO();
        if (loggingEvent.getMessage() instanceof LogRecordJDO) {
            logRecordJDO = (LogRecordJDO)loggingEvent.getMessage();
        } else {
            logRecordJDO.setLogMessage(loggingEvent.getMessage().toString());
        }
        if (this.getURL().toUpperCase().contains(POSTGRES)) {
            logRecordJDO.setDatabaseType(LogRecordJDO.Database.POSTGRES);
            loggingEvent.setProperty(DATABASE_TYPE, POSTGRES);
        } else if (this.getURL().toUpperCase().contains(ORACLE)) {
            logRecordJDO.setDatabaseType(LogRecordJDO.Database.ORACLE);
            loggingEvent.setProperty(DATABASE_TYPE, ORACLE);
        }
        LoggingEvent loggingEvent2 = new LoggingEvent(loggingEvent.getFQNOfLoggerClass(), loggingEvent.getLogger(), loggingEvent.getTimeStamp(), loggingEvent.getLevel(), (Object)logRecordJDO, loggingEvent.getThreadName(), loggingEvent.getThrowableInformation(), loggingEvent.getNDC(), loggingEvent.getLocationInformation(), loggingEvent.getProperties());
        LogLog.debug((String)("Database type is: " + (Object)((Object)((LogRecordJDO)loggingEvent2.getMessage()).getDatabaseType())));
        return super.getLogStatement(loggingEvent2);
    }

    protected void execute(Connection connection, String string) throws SQLException {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            if (statement != null) {
                statement.close();
            }
            throw sQLException;
        }
        statement.close();
    }

    public void flushBuffer() {
        Connection connection = null;
        this.removes.ensureCapacity(this.buffer.size());
        try {
            connection = this.getConnection();
            Iterator iterator = this.buffer.iterator();
            while (iterator.hasNext()) {
                LoggingEvent loggingEvent = (LoggingEvent)iterator.next();
                String string = this.getLogStatement(loggingEvent);
                this.execute(connection, string);
                this.removes.add(loggingEvent);
                iterator.remove();
            }
        }
        catch (SQLException sQLException) {
            this.errorHandler.error("Failed to excute sql", (Exception)sQLException, 2);
        }
        this.closeConnection(connection);
        this.removes.clear();
    }
}

