package com.avaya.zephyr.services.sample_services.CallableService.attributeReaders;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.powermock.modules.junit4.PowerMockRunner;
import static org.mockito.Mockito.when;
import static org.junit.Assert.assertEquals;
import com.avaya.collaboration.businessdata.api.NoAttributeFoundException;
import com.avaya.collaboration.util.logger.Logger;
import com.avaya.zephyr.platform.dao.ClusterAttributeDAO;
@RunWith(PowerMockRunner.class)
public class ClusterAttributeReaderImplTest {
	
	private ClusterAttributeReaderImpl clusterAttributeReaderImpl;
	
	@Mock
	private ClusterAttributeDAO clusterAttributeDAO;
	
	@Mock
	Logger logger;
	
	
	@Before
	public void setUp() throws Exception
	{
		clusterAttributeReaderImpl = new ClusterAttributeReaderImpl(clusterAttributeDAO, logger);
		when(logger.isFinerEnabled()).thenReturn(true);
		when(logger.isFinestEnabled()).thenReturn(true);
	}
	
	@Test
	public void getAnnouncementFileNetworkProtocol() throws NoAttributeFoundException
	{
		when(clusterAttributeDAO.getClusterAttribute("HttpsOnly")).thenReturn("true");
		String protocol1 = clusterAttributeReaderImpl.getAnnouncementFileNetworkProtocol();
		when(logger.isFinestEnabled()).thenReturn(false);
		when(clusterAttributeDAO.getClusterAttribute("HttpsOnly")).thenReturn("false");
		String protocol2 = clusterAttributeReaderImpl.getAnnouncementFileNetworkProtocol();
		assertEquals(protocol1, "https");
		assertEquals(protocol2, "http");
	}
	
	@Test
	public void getDefaultClusterDomain() throws NoAttributeFoundException {
		when(clusterAttributeDAO.getClusterAttribute("SIPDefaultDomain")).
		thenReturn("sip:alice@example.sip.avaya.com");
		String clusterDomain = clusterAttributeReaderImpl.getDefaultClusterDomain();
		assertEquals(clusterDomain, "sip:alice@example.sip.avaya.com");
	}
}
