/*****************************************************************************
 * Â© 2015 Avaya Inc. All rights reserved.
 ****************************************************************************/
package com.avaya.zephyr.services.sample_services.ClickToCall;

import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;
import static org.junit.Assert.assertEquals;
import org.junit.Before;
import org.junit.Test;
import com.avaya.collaboration.call.Call;
import com.avaya.collaboration.call.Participant;
import com.avaya.collaboration.util.logger.Logger;

public final class TwoPartyCallManagerResourceTest
{
    private static final String DOMAIN_DELIMITER_AT = "@";
    private static final String DOMAIN = "avaya.com";
    private static final String FIRST_PARTY = "3403@avaya.com";
    private static final String SECOND_PARTY = "3404@avaya.com";
    private static final String FIRST_PARTY_NO_DOMAIN = "3403";
    private static final String SECOND_PARTY_NO_DOMAIN = "3404";
    private static final String CALLING_ID_NO_DOMAIN = "3402";
    private Call call;
    private Participant firstParty, secondParty;
    private RequestProcessor requestProcessorImpl;
    private TwoPartyCallManagerResource twoPartyCallManagerResource;
    private Logger logger;

    @Before
    public void setUp()
    {
        call = mock(Call.class);
        firstParty = mock(Participant.class);
        secondParty = mock(Participant.class);
        requestProcessorImpl = mock(RequestProcessor.class);
        logger = mock(Logger.class);

        when(firstParty.getHandle()).thenReturn(FIRST_PARTY_NO_DOMAIN);
        when(firstParty.getDomain()).thenReturn(DOMAIN);
        when(firstParty.getAddress()).thenReturn(FIRST_PARTY);
        when(secondParty.getHandle()).thenReturn(SECOND_PARTY_NO_DOMAIN);
        when(secondParty.getDomain()).thenReturn(DOMAIN);
        when(secondParty.getAddress()).thenReturn(SECOND_PARTY);
        when(call.getCallingParty()).thenReturn(firstParty);
        when(call.getCalledParty()).thenReturn(secondParty);

        twoPartyCallManagerResource = new TwoPartyCallManagerResource(requestProcessorImpl, logger);
    }

    @Test
    public void doPost_isValidBody() throws Exception
    {
        final String startBody = "first=";
        final String midBody = "&second=";
        final String callingId = "&calling="+CALLING_ID_NO_DOMAIN;
        final String firstPartOfBody = startBody + firstParty.getHandle()+ DOMAIN_DELIMITER_AT + firstParty.getDomain();
        final String secondPartOfBody = midBody + secondParty.getHandle()+ DOMAIN_DELIMITER_AT + secondParty.getDomain();
        final String postBody = firstPartOfBody + secondPartOfBody + callingId;
        final String expectedPostMessage = "doPost: request submitted, post body= "+ postBody;

        assertEquals(expectedPostMessage, twoPartyCallManagerResource.doPost(postBody));
    }
} 
