/*****************************************************************************
© 2017 Avaya Inc. All rights reserved. 
****************************************************************************/

package com.avaya.zephyr.services.sample_services.OutboundHttpsSample;

import static org.mockito.Mockito.when;

import org.apache.http.impl.client.CloseableHttpClient;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.reflect.Whitebox;

import com.avaya.collaboration.util.logger.Logger;

@RunWith(PowerMockRunner.class)
@PrepareForTest({ HttpClientSingleton.class, CloseableHttpClient.class, Logger.class })
public final class CertificateChangePlatformListenerTest
{
    private CertificateChangePlatformListener certificateChangePlatformListener;

    @Mock
    private CloseableHttpClient httpClientMock;

    private Logger loggerMock;

    private HttpClientSingleton httpClientSingletonInstanceMock;
    
    @Before
    public void setup() throws Exception
    {
        loggerMock = PowerMockito.mock(Logger.class);
        PowerMockito.mockStatic(Logger.class);
        when(Logger.getLogger(HttpClientSingleton.class)).thenReturn(loggerMock);

        httpClientMock = PowerMockito.mock(CloseableHttpClient.class);

        httpClientSingletonInstanceMock = PowerMockito.mock(HttpClientSingleton.class);
        Whitebox.setInternalState(HttpClientSingleton.class, "INSTANCE", httpClientSingletonInstanceMock);
        when(httpClientSingletonInstanceMock.reset()).thenReturn(httpClientMock);

        certificateChangePlatformListener = new CertificateChangePlatformListener(loggerMock);
    }

    @Test
    public void certificateStoreUpdated() throws Exception
    {
        certificateChangePlatformListener.certificateStoreUpdated();
    }
}
