/*****************************************************************************
 * © 2015 Avaya Inc. All rights reserved.
 ****************************************************************************/
package com.avaya.zephyr.services.sample_services.CallableService.attributeReaders;

import com.avaya.asm.datamgr.DMFactory;
import com.avaya.collaboration.businessdata.api.NoAttributeFoundException;
import com.avaya.collaboration.util.logger.Logger;
import com.avaya.zephyr.platform.dao.ClusterAttributeDAO;

public final class ClusterAttributeReaderImpl implements ClusterAttributeReader
{
    private final ClusterAttributeDAO clusterAttributeDAO;
    private final Logger logger;

    public ClusterAttributeReaderImpl()
    {
        this((ClusterAttributeDAO) DMFactory.getInstance().getDataMgr(ClusterAttributeDAO.class),
                Logger.getLogger(ClusterAttributeReaderImpl.class));
    }

    ClusterAttributeReaderImpl(final ClusterAttributeDAO clusterAttributeDAO, final Logger logger)
    {
        this.clusterAttributeDAO = clusterAttributeDAO;
        this.logger = logger;
    }

    @Override
    public String getAnnouncementFileNetworkProtocol() throws NoAttributeFoundException
    {
        final String httpsOnly = clusterAttributeDAO.getClusterAttribute("HttpsOnly");

        if (logger.isFinestEnabled())
        {
            logger.finest("getAnnouncementFileNetworkProtocol: security=" + httpsOnly);
        }

        if (httpsOnly.contentEquals("true"))
        {
            return "https";
        }
        else
        {
            return "http";
        }
    }

    @Override
    public String getDefaultClusterDomain() throws NoAttributeFoundException
    {
        final String sipDefaultDomain = clusterAttributeDAO.getClusterAttribute("SIPDefaultDomain");

        if (logger.isFinestEnabled())
        {
            logger.finest("getDefaultClusterDomain: sip default domain=" + sipDefaultDomain);
        }

        return sipDefaultDomain;
    }
}
