/*****************************************************************************
 * © 2015 Avaya Inc. All rights reserved.
 ****************************************************************************/
package com.avaya.zephyr.services.sample_services.CallableService.attributeReaders;

import com.avaya.collaboration.businessdata.api.NoAttributeFoundException;
import com.avaya.collaboration.businessdata.api.NoServiceProfileFoundException;
import com.avaya.collaboration.businessdata.api.NoUserFoundException;
import com.avaya.collaboration.businessdata.api.ServiceData;
import com.avaya.collaboration.businessdata.api.ServiceNotFoundException;
import com.avaya.collaboration.call.Participant;
import com.avaya.collaboration.dal.factory.CollaborationDataFactory;
import com.avaya.zephyr.platform.dal.api.ServiceDescriptor;
import com.avaya.zephyr.platform.dal.api.ServiceUtil;

/**
 * This retrieves the attributes associated with the service.
 * 
 * @see <code>properties.xml</code>
 */
public final class ServiceAttributeReaderImpl implements ServiceAttributeReader
{

    private final ServiceData serviceData;

    public ServiceAttributeReaderImpl()
    {
        this(ServiceUtil.getServiceDescriptor());
    }

    ServiceAttributeReaderImpl(final ServiceDescriptor serviceDescriptor)
    {
        this.serviceData = CollaborationDataFactory.getServiceData(serviceDescriptor.getName(),
                serviceDescriptor.getVersion());
    }

    @Override
    public String getFileName(final Participant participantUserAddress) throws NoUserFoundException,
            NoAttributeFoundException,
            ServiceNotFoundException, NoServiceProfileFoundException
    {
        final String participantAddress = participantUserAddress.getAddress();
        final String fileName = serviceData.getServiceAttribute(participantAddress, "fileName");

        return fileName;
    }
}
