/*****************************************************************************
 * © 2015 Avaya Inc. All rights reserved.
 ****************************************************************************/

package com.avaya.zephyr.services.sample_services.CallableService;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;
import static org.mockito.Mockito.never;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.powermock.modules.junit4.PowerMockRunner;

import com.avaya.collaboration.call.Call;
import com.avaya.collaboration.util.logger.Logger;
import com.avaya.zephyr.services.sample_services.CallableService.operations.PlayAnnouncementOperation;

@RunWith(PowerMockRunner.class)
public class CallableServiceCallListenerTest
{

    CallableServiceCallListener callableServiceCallListener;

    @Mock
    private PlayAnnouncementOperation playAnnouncementOperation;
    @Mock
    Call call;
    @Mock
    Logger logger;

    @Before
    public void setUp()
    {
        callableServiceCallListener = new CallableServiceCallListener(playAnnouncementOperation, logger);
        when(logger.isFinestEnabled()).thenReturn(true);
        when(logger.isFinerEnabled()).thenReturn(true);
    }

    @Test
    public void callIntercepted()
    {
    	when(call.wasServiceCalled()).thenReturn(false);
        callableServiceCallListener.callIntercepted(call);
        verify(playAnnouncementOperation, never()).executePlayAnnouncementOperation(call, PromptsToPlay.GREETING);
        when(call.wasServiceCalled()).thenReturn(true);
        callableServiceCallListener.callIntercepted(call);
        verify(playAnnouncementOperation).executePlayAnnouncementOperation(call, PromptsToPlay.GREETING);
    }
}
