/*****************************************************************************
© 2017 Avaya Inc. All rights reserved. 
****************************************************************************/
package com.avaya.zephyr.services.sample_services.OutboundHttpsSample;

import java.io.IOException;

import com.avaya.collaboration.platformlistener.PlatformListenerAbstract;
import com.avaya.collaboration.platformlistener.ThePlatformListener;
import com.avaya.collaboration.ssl.util.SSLUtilityException;
import com.avaya.collaboration.util.logger.Logger;

@ThePlatformListener
public class CertificateChangePlatformListener extends PlatformListenerAbstract
{
    private final Logger logger;

    public CertificateChangePlatformListener()
    {
        this(Logger.getLogger(CertificateChangePlatformListener.class));
    }
    
    CertificateChangePlatformListener(final Logger logger)
    {
        this.logger = logger;
    }
    
    @Override
    public final void certificateStoreUpdated()
    {
        try
        {
            HttpClientSingleton.INSTANCE.reset();
        }
        catch (final IOException | SSLUtilityException e)
        {
            logger.error("CertificateChangePlatformListener certificateStoreUpdated " +
                    "CERTIFICATE update failed." + e.getMessage());
        }
        logger.info("CertificateChangePlatformListener certificateStoreUpdated CERTIFICATE updated");
    }
}
