/*****************************************************************************
© 2017 Avaya Inc. All rights reserved. 
****************************************************************************/

package com.avaya.zephyr.services.sample_services.OutboundHttpsSample;

import static org.mockito.Mockito.when;

import java.io.IOException;

import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.powermock.modules.junit4.PowerMockRunner;

import com.avaya.collaboration.businessdata.api.NoAttributeFoundException;
import com.avaya.collaboration.businessdata.api.NoServiceProfileFoundException;
import com.avaya.collaboration.businessdata.api.NoUserFoundException;
import com.avaya.collaboration.businessdata.api.ServiceData;
import com.avaya.collaboration.businessdata.api.ServiceNotFoundException;
import com.avaya.collaboration.ssl.util.SSLUtilityException;

@RunWith(PowerMockRunner.class)
public final class HttpRequestResourceTest
{
    @Mock
    private ServiceData svcDataMock;
    @Mock
    private HttpClient clientMock;
    @Mock
    HttpClientProvider httpClientSingletonMock;
    @Mock
    HttpResponse mockResponse;
    
    private HttpRequestResource testObject;

    @Before
    public void setup() throws SSLUtilityException
    {
        when(httpClientSingletonMock.getHttpClientBasedOnSSLContext()).thenReturn(clientMock);
        testObject = new HttpRequestResourceImpl(svcDataMock, httpClientSingletonMock);
    }

    @Test
    public void accountDetails() throws NoUserFoundException, ServiceNotFoundException,
            NoAttributeFoundException, NoServiceProfileFoundException, IOException, SSLUtilityException
    {
        when(svcDataMock.getServiceAttribute("com.avaya.sample.zang.accountid")).thenReturn("account1");
        when(svcDataMock.getServiceEncryptedAttribute("com.avaya.sample.zang.authtoken")).thenReturn("authCode");

        when(clientMock.execute(Mockito.any(HttpGet.class))).thenReturn(mockResponse);
        when(mockResponse.getEntity()).thenReturn(new StringEntity("test account details"));

        final String result = testObject.accountDetails();
        
        Assert.assertEquals("test account details", result);
    }

    @Test
    public void carrierLookUp() throws NoUserFoundException, ServiceNotFoundException,
            NoAttributeFoundException, NoServiceProfileFoundException, ClientProtocolException, IOException,
            SSLUtilityException
    {
        when(svcDataMock.getServiceAttribute("com.avaya.sample.zang.accountid")).thenReturn("account1");
        when(svcDataMock.getServiceEncryptedAttribute("com.avaya.sample.zang.authtoken")).thenReturn("authCode");
        when(svcDataMock.getServiceAttribute("com.avaya.sample.phonenumber")).thenReturn("9876543245");

        when(clientMock.execute(Mockito.any(HttpPost.class))).thenReturn(mockResponse);
        when(mockResponse.getEntity()).thenReturn(new StringEntity("test carrier look up details"));

        final String result = testObject.carrierLookUp();
        
        Assert.assertEquals("test carrier look up details", result);
    }
}
