package com.avaya.services.whitelist;

import com.avaya.collaboration.call.Call;
import com.avaya.collaboration.service.ServiceListener;
import com.avaya.collaboration.service.TheServiceListener;
import com.avaya.collaboration.util.logger.Logger;


@TheServiceListener
public  final class WhiteListServiceListener implements ServiceListener
{
    public static final String REMOVE_SERVICE_SUCCEEDED = "ServiceListener.removeServiceFromCallSucceeded";
    public static final String REMOVE_SERVICE_FAILED = "ServiceListener.removeServiceFromCallFailed";
    private final transient Logger logger;
    private static final long serialVersionUID = 1L;

    public WhiteListServiceListener()
    {
        this(Logger.getLogger(WhiteListServiceListener.class));
    }

    WhiteListServiceListener(final Logger logger)
    {
        this.logger = logger;
    }

    public void removeServiceFromCallSucceeded(final Call call)
    {
        logger.info("removeServiceFromCallSucceeded for callId=" + call.getId());
    }

    public void removeServiceFromCallFailed(final Call call, final String reason)
    {
        logger.info("removeServiceFromCallFailed for callId=" + call.getId() + "; reason: " + reason);
    }
}
