/*****************************************************************************
 * © 2017 Avaya Inc. All rights reserved.
 ****************************************************************************/
package com.avaya.services.CallDeflection.util;

import com.avaya.collaboration.businessdata.api.NoAttributeFoundException;
import com.avaya.collaboration.businessdata.api.NoServiceProfileFoundException;
import com.avaya.collaboration.businessdata.api.NoUserFoundException;
import com.avaya.collaboration.businessdata.api.ServiceData;
import com.avaya.collaboration.businessdata.api.ServiceNotFoundException;
import com.avaya.collaboration.dal.factory.CollaborationDataFactory;
import com.avaya.collaboration.util.logger.Logger;
import com.avaya.zephyr.platform.dal.api.ServiceDescriptor;
import com.avaya.zephyr.platform.dal.api.ServiceUtil;

/**
 * This retrieves the attributes associated with the service.
 * 
 * @see <code>properties.xml</code>
 */
public final class ServiceAttributeReaderImpl implements ServiceAttributeReader
{
    private final ServiceData serviceData;

    private final Logger logger;

    public ServiceAttributeReaderImpl()
    {
        this(ServiceUtil.getServiceDescriptor(), Logger.getLogger(ServiceAttributeReaderImpl.class));
    }

    ServiceAttributeReaderImpl(final ServiceDescriptor serviceDescriptor, final Logger logger)
    {
        this.serviceData = CollaborationDataFactory.getServiceData(serviceDescriptor.getName(),
                serviceDescriptor.getVersion());

        this.logger = logger;
    }

    @Override
    public String getAgentNumber() throws NoUserFoundException,
            NoAttributeFoundException, ServiceNotFoundException, NoServiceProfileFoundException
    {
        return serviceData.getServiceAttribute("com.avaya.example.agentNumber");

    }

    @Override
    public String getAgentDomain() throws NoUserFoundException,
            NoAttributeFoundException, ServiceNotFoundException, NoServiceProfileFoundException
    {
        return serviceData.getServiceAttribute("com.avaya.example.agentDomian");
    }

    @Override
    public String getAnnouncementSourcePath() throws NoAttributeFoundException, ServiceNotFoundException
    {
        final String sourcePath = serviceData.getServiceAttribute("com.avaya.example.sourcePath");

        if (logger.isFinestEnabled())
        {
            logger.finest("getAnnouncementSource: " + sourcePath);
        }
        return sourcePath;
    }

    @Override
    public String getEmailTo() throws NoAttributeFoundException, ServiceNotFoundException
    {
        return serviceData.getServiceAttribute("com.avaya.example.emailTo");
    }

    @Override
    public String getEmailFrom() throws NoAttributeFoundException, ServiceNotFoundException
    {
        return serviceData.getServiceAttribute("com.avaya.example.emailFrom");
    }

    @Override
    public String getSmsFrom() throws NoAttributeFoundException, ServiceNotFoundException
    {
        return serviceData.getServiceAttribute("com.avaya.example.smsFrom");
    }

    @Override
    public String getSmsTo() throws NoAttributeFoundException, ServiceNotFoundException
    {
        return serviceData.getServiceAttribute("com.avaya.example.smsTo");
    }
}
