package com.avaya.zephyr.services.sample_services.CallableService.menus;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import java.util.UUID;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

import com.avaya.collaboration.call.Call;
import com.avaya.collaboration.call.media.DigitCollectorOperationCause;
import com.avaya.collaboration.util.logger.Logger;
import com.avaya.zephyr.services.sample_services.CallableService.PromptsToPlay;
import com.avaya.zephyr.services.sample_services.CallableService.operations.PlayAnnouncementOperation;
import com.avaya.zephyr.services.sample_services.CallableService.operations.PromptAndCollectOperation;

@RunWith(PowerMockRunner.class)
@PrepareForTest({ PlayAnnouncementOperation.class })
public class CallableServiceSubMenuMediaListenerTest
{

    CallableServiceSubMenuMediaListener callableServiceSubMenuMediaListener;

    @Mock
    PlayAnnouncementOperation playAnnouncementOperation;
    @Mock
    PromptAndCollectOperation promptAndCollectOperation;

    @Mock
    Call call;

    @Mock
    Logger logger;

    DigitCollectorOperationCause CAUSE = DigitCollectorOperationCause.NUMBER_OF_DIGITS;

    @Before
    public void setUp()
    {
    	
        callableServiceSubMenuMediaListener =
                new CallableServiceSubMenuMediaListener(call, playAnnouncementOperation,
                        promptAndCollectOperation, logger);
        when(logger.isFinerEnabled()).thenReturn(true);
    }

    @Test
    public void digitsCollected_approve_recording()
    {
    	when(call.getAttribute("nextPrompt")).thenReturn(PromptsToPlay.MAINMENU);
        callableServiceSubMenuMediaListener.digitsCollected(UUID.randomUUID(), "1", CAUSE);
        verify(promptAndCollectOperation, Mockito.times(1)).executePromptAndCollectOperation(call,
                PromptsToPlay.MAINMENU);
        when(logger.isFinerEnabled()).thenReturn(false);
        when(call.getAttribute("nextPrompt")).thenReturn(PromptsToPlay.RECORD);
        callableServiceSubMenuMediaListener.digitsCollected(UUID.randomUUID(), "1", CAUSE);
        verify(logger, Mockito.never()).error(Mockito.any());
    }

    @Test
    public void digitsCollected_discard_recording()
    {
    	callableServiceSubMenuMediaListener.digitsCollected(UUID.randomUUID(), "2", CAUSE);
        verify(call).setAttribute("nextPrompt", PromptsToPlay.BEEP);
        verify(logger, Mockito.never()).error(Mockito.any());
    }

    @Test
    public void digitsCollected_exit_recording()
    {
    	callableServiceSubMenuMediaListener.digitsCollected(UUID.randomUUID(), "*", CAUSE);
        verify(logger, Mockito.never()).error(Mockito.any());
    }
    
    @Test
    public void digitsCollected_invalid_input()
    {
    	callableServiceSubMenuMediaListener.digitsCollected(UUID.randomUUID(), "9", CAUSE);
        verify(logger, Mockito.times(1)).error(Mockito.any());
    }
}
