/////////////////////////////////////////////////////////////////////////////
//Copyright Avaya Inc., All Rights Reserved
// THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AVAYA INC
// The copyright notice above does not evidence any
// actual or intended publication of such source code.
// Some third-party source code components may have been modified from
// their original versions by Avaya Inc.
// The modifications are Copyright Avaya Inc., All Rights Reserved.
//
//////////////////////////////////////////////////////////////////////////////

package com.avaya.services.whitelist.rest;

import java.util.List;

import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import com.avaya.collaboration.call.Call;
import com.avaya.collaboration.call.CallFactory;
import com.avaya.collaboration.service.ServiceManager;
import com.avaya.collaboration.util.logger.Logger;
import com.avaya.services.whitelist.db.WhiteListDao;
import com.avaya.services.whitelist.db.WhiteListEntry;
import com.google.gson.Gson;

@Path("/entry")
@Stateless
public class WhitelistResource
{
    private Logger logger = Logger.getLogger(WhitelistResource.class);

    @EJB
    private WhiteListDao whiteListDao;

    @POST
    @Path("/callingParty/{callingParty}/calledParty/{calledParty}")
    @Produces(MediaType.APPLICATION_JSON)
    public List<WhiteListEntry> createWhitelistEntry(@Context HttpServletRequest request,
            @PathParam(value = "callingParty") String callingParty,
            @PathParam(value = "calledParty") String calledParty)
    {
        logger.fine("Inside REST : WhitelistResource :: createWhiteListEntries ");
        List<WhiteListEntry> whiteListEntryList = null;
        if (isValidRequest(request))
        {
            whiteListEntryList = whiteListDao.createWhiteListEntry(callingParty, calledParty);
        }
        return whiteListEntryList;
    }

    private boolean isValidRequest(final HttpServletRequest request)
    {
        logger.fine("Testing HttpServlet Request" + request);
        // Validate the request to protect against CSRF, XSS etc.
        // Read more about CSRF and protection implementation against it
        // https://www.owasp.org/index.php/Cross-Site_Request_Forgery_(CSRF)_Prevention_Cheat_Sheet.
        return true;
    }

    @GET
    @Path("/callingParty/{callingParty}/calledParty/{calledParty}")
    @Produces(MediaType.APPLICATION_JSON)
    public Response queryOneEntry(@Context HttpServletRequest request, @PathParam(value = "callingParty") String callingParty,
            @PathParam(value = "calledParty") String calledParty)
    {
        logger.fine("Inside REST : WhitelistResource :: queryOneEntry");
        List<WhiteListEntry> tmpwhiteListEntryList = null;
        List<WhiteListEntry> whiteListEntryList = null;

        if (isValidRequest(request))
        {
            tmpwhiteListEntryList = whiteListDao.queryOneEntry(callingParty, calledParty);

            if ((tmpwhiteListEntryList != null))
            {
                whiteListEntryList = tmpwhiteListEntryList;
            }
            if (whiteListEntryList == null)
            {
                return Response.status(Response.Status.NOT_FOUND)
                        .entity("Entry not found for CallingParty: " + callingParty + "  CalledParty :" + calledParty).build();

            }
            else
            {
                String json = new Gson().toJson(whiteListEntryList);
                return Response.ok(json, MediaType.APPLICATION_JSON).build();
            }

        }

        else
        {
            return Response.status(Response.Status.UNAUTHORIZED)
                    .entity("Request Unauthorized").build();
        }
    }

    @GET
    @Path("/calledParty/{calledParty}")
    @Produces(MediaType.APPLICATION_JSON)
    public Response queryOneEntryByCalledHandle(@Context HttpServletRequest request, @PathParam(value = "calledParty") String calledParty)
    {
        logger.fine("Inside REST : WhitelistResource :: queryOneEntryByCalledHandle ");
        List<WhiteListEntry> tmpwhiteListEntryList = null;
        List<WhiteListEntry> whiteListEntryList = null;

        if (isValidRequest(request))
        {
            tmpwhiteListEntryList = whiteListDao.queryEntryByCalledHandle(calledParty);

            if ((tmpwhiteListEntryList != null))
            {
                whiteListEntryList = tmpwhiteListEntryList;
            }

            if (whiteListEntryList == null)
            {
                return Response.status(Response.Status.NOT_FOUND).entity("Entry not found for CalledParty :" + calledParty).build();

            }
            else
            {
                String json = new Gson().toJson(whiteListEntryList);
                return Response.ok(json, MediaType.APPLICATION_JSON).build();
            }
        }
        else
        {
            return Response.status(Response.Status.UNAUTHORIZED).entity("Request Unauthorized").build();
        }
    }

    @DELETE
    @Path("/callingParty/{callingParty}/calledParty/{calledParty}")
    @Produces(MediaType.APPLICATION_JSON)
    public Response removeWhitelistEntry(@Context HttpServletRequest request, @PathParam(value = "callingParty") String callingParty,
            @PathParam(value = "calledParty") String calledParty)
    {
        logger.fine("Inside REST : WhitelistResource :: removeWhiteListEntries ");
        List<WhiteListEntry> whiteListEntryList = null;

        if (isValidRequest(request))
        {
            whiteListEntryList = whiteListDao.deleteWhiteListEntry(callingParty, calledParty);

            if (whiteListEntryList == null)
            {
                return Response.status(Response.Status.NOT_FOUND)
                        .entity("Entry not found for CallingParty: " + callingParty + "  CalledParty :" + calledParty).build();

            }
            else
            {
                String json = new Gson().toJson(whiteListEntryList);
                return Response.ok(json, MediaType.APPLICATION_JSON).build();
            }
        }
        else
        {
            return Response.status(Response.Status.UNAUTHORIZED)
                    .entity("Request Unauthorized").build();
        }
    }

    @GET
    @Path("/removeServiceFromCall/{callId}")
    public String removeServiceFromCall(@PathParam(value = "callId") String callId)
    {
        logger.finest("removeServiceFromCall callId=" + callId);
        final Call call = CallFactory.getCall(callId);
        logger.finest("removeServiceFromCall call=" + call);

        ServiceManager.removeServiceFromCall(call);

        return "called removeServiceFromCall on call=" + call.getId();
    }
}
