/*****************************************************************************
 * © 2017 Avaya Inc. All rights reserved.
 ****************************************************************************/
package com.avaya.services.CallDeflection.email;

import org.apache.commons.lang3.StringUtils;

import com.avaya.collaboration.businessdata.api.NoAttributeFoundException;
import com.avaya.collaboration.businessdata.api.ServiceNotFoundException;
import com.avaya.collaboration.email.EmailFactory;
import com.avaya.collaboration.email.EmailRequest;
import com.avaya.collaboration.util.logger.Logger;
import com.avaya.services.CallDeflection.util.ServiceAttributeReader;
import com.avaya.services.CallDeflection.util.ServiceAttributeReaderImpl;

public class CallDeflectionEmailSender
{
    private final Logger logger;
    private final ServiceAttributeReader serviceAttributeReader;

    private static final String EMAIL_INFO_NOT_SENT_LOG = "Info: Email will not be sent.";
    private static final String EMAIL_ERROR_SEND_LOG = "Error: Error occured sending email.";
    private static final String EMAIL_INFO_USE_EC_FROM_LOG =
            "Will attempt to use the email connector's 'default sender' attribute for the 'from' address.";
    private static final String EMAIL_INFO_SENT_LOG = "Info: Email queued to be sent to ";
    private static final String CALL_DEFLECTION_DEMO = "CallDeflection Demo";

    public CallDeflectionEmailSender()
    {
        this(new ServiceAttributeReaderImpl(), Logger.getLogger(CallDeflectionEmailSender.class));
    }

    public CallDeflectionEmailSender(final ServiceAttributeReader serviceAttributeReader, final Logger logger)
    {
        this.serviceAttributeReader = serviceAttributeReader;
        this.logger = logger;
    }

    public final boolean sendEmail() throws NoAttributeFoundException, ServiceNotFoundException
    {
        boolean emailSent = false;

        final String emailTo = serviceAttributeReader.getEmailTo();

        if (StringUtils.isBlank(emailTo))
        {
            logInfo(EMAIL_INFO_NOT_SENT_LOG);
        }
        else
        {
            final String emailFrom = serviceAttributeReader.getEmailFrom();

            if (StringUtils.isBlank(emailFrom))
            {
                logInfo(EMAIL_INFO_USE_EC_FROM_LOG);
            }

            final EmailRequest emailRequest = EmailFactory.createEmailRequest();
            emailRequest.setFrom(emailFrom);
            emailRequest.getTo().add(emailTo);
            emailRequest.setSubject(CALL_DEFLECTION_DEMO);
            emailRequest.setTextBody(CALL_DEFLECTION_DEMO);

            // Create the listener and send the email message
            final CallDeflectionEmailListener callDeflectionEmailListener = new CallDeflectionEmailListener(emailRequest);
            emailRequest.setListener(callDeflectionEmailListener);

            try
            {
                emailRequest.send();
                logSendSuccess(emailRequest);
                emailSent = true;
            }
            catch (final Exception e)
            {
                logger.error(EMAIL_ERROR_SEND_LOG, e);
            }
        }

        return emailSent;
    }

    private void logSendSuccess(final EmailRequest emailRequest)
    {
        // List of email addresses this request is queued to
        // be sent to
        final StringBuilder emailAddress = new StringBuilder();
        for (final String emailTo : emailRequest.getTo())
        {
            if (emailAddress.length() == 0)
            {
                emailAddress.append(emailTo);
            }
            else
            {
                emailAddress.append(", ").append(emailTo);
            }
        }

        logInfo(EMAIL_INFO_SENT_LOG + emailAddress.toString());
    }

    private void logInfo(final String log)
    {
        logger.info(log);
    }
}
