/*****************************************************************************
 * © 2015 Avaya Inc. All rights reserved.
 ****************************************************************************/
package com.avaya.zephyr.services.sample_services.CallableService.util;

import com.avaya.collaboration.businessdata.api.NoAttributeFoundException;
import com.avaya.collaboration.call.Call;
import com.avaya.collaboration.call.media.DigitOptions;
import com.avaya.collaboration.call.media.PlayItem;
import com.avaya.collaboration.call.media.RecordItem;
import com.avaya.collaboration.util.logger.Logger;
import com.avaya.zephyr.services.sample_services.CallableService.attributeReaders.ClusterAttributeReader;
import com.avaya.zephyr.services.sample_services.CallableService.attributeReaders.ClusterAttributeReaderImpl;
import com.avaya.zephyr.services.sample_services.CallableService.attributeReaders.TrafficInterfaceAddressRetriever;
import com.avaya.zephyr.services.sample_services.CallableService.attributeReaders.TrafficInterfaceAddressRetrieverImpl;

public final class CallableServiceUtil
{
    private final ClusterAttributeReader clusterAttributeReader;
    private final TrafficInterfaceAddressRetriever trafficInterfaceAddressRetriever;

    public CallableServiceUtil()
    {
        this(new ClusterAttributeReaderImpl(), new TrafficInterfaceAddressRetrieverImpl());
    }

    CallableServiceUtil(final ClusterAttributeReader clusterAttributeReader,
            final TrafficInterfaceAddressRetriever trafficInterfaceAddressRetriever)
    {
        this.clusterAttributeReader = clusterAttributeReader;
        this.trafficInterfaceAddressRetriever = trafficInterfaceAddressRetriever;
    }

    public String buildUri() throws NoAttributeFoundException
    {
        final String announcementFileNetworkProtocol =
                clusterAttributeReader.getAnnouncementFileNetworkProtocol();
        final String trafficInterfaceAddress = trafficInterfaceAddressRetriever.getTrafficInterfaceAddress();
        final StringBuffer buildUri = new StringBuffer();
        buildUri.append(announcementFileNetworkProtocol).append("://").append(trafficInterfaceAddress)
                .append("/services/CallableService/");

        return buildUri.toString();
    }

    public void writeLog(final Class<?> classInstance, final Call call, final PlayItem playItem,
            final Logger logger)
    {
        if (logger.isFinestEnabled())
        {
            final String className = classInstance.getCanonicalName();
            logger.finest(className + ": call=" + call + "; play=" + playItem + ";");
        }
    }

    public void writeLog(final Class<?> classInstance, final Call call, final DigitOptions digitOptions,
            final PlayItem playItem, final Logger logger)
    {
        if (logger.isFinestEnabled())
        {
            final String className = classInstance.getCanonicalName();
            logger.finest(className + ": call=" + call + "; prompt and collect=" +
                    playItem + "; digit options=" + digitOptions);
        }
    }

    public void writeLog(final Class<?> classInstance, final Call call, final RecordItem recordItem,
            final Logger logger)
    {
        if (logger.isFinestEnabled())
        {
            final String className = classInstance.getCanonicalName();
            logger.finest(className + ": call=" + call + "; record=" + recordItem + ";");
        }
    }
}
