/////////////////////////////////////////////////////////////////////////////
//Copyright Avaya Inc., All Rights Reserved
// THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AVAYA INC
// The copyright notice above does not evidence any
// actual or intended publication of such source code.
// Some third-party source code components may have been modified from
// their original versions by Avaya Inc.
// The modifications are Copyright Avaya Inc., All Rights Reserved.
//
//////////////////////////////////////////////////////////////////////////////
package com.avaya.services.whitelist;

import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.when;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

import com.avaya.collaboration.businessdata.api.ServiceData;
import com.avaya.collaboration.call.Participant;
import com.avaya.collaboration.dal.factory.CollaborationDataFactory;
import com.avaya.zephyr.platform.dal.api.ServiceDescriptor;

@RunWith(PowerMockRunner.class)
@PrepareForTest(
{ CollaborationDataFactory.class, ServiceDescriptor.class })
public final class AlternateDestinationFinderImplTest
{
    private AlternateDestinationFinder alternateDestinationFinder;

    @Mock
    private ServiceDescriptor serviceDescriptorMock;

    @Mock
    private ServiceData serviceDataMock;
    @Mock
    private Participant calledParticipantMock;

    private final String serviceName = "WhiteList";
    private final String serviceVersion = "3.3.0.0.0";

    private static final String defaultAddress = "+17205551212";

    private static final String redirectNumberAttribute = AlternateDestinationFinderImpl.REDIRECT_NUMBER_ATTRIBUTE;

    @Before
    public void setUp()
    {
        PowerMockito.mockStatic(CollaborationDataFactory.class);

        when(CollaborationDataFactory.getServiceData(serviceName, serviceVersion)).thenReturn(serviceDataMock);

        when(serviceDescriptorMock.getName()).thenReturn(serviceName);
        when(serviceDescriptorMock.getVersion()).thenReturn(serviceVersion);
        when(calledParticipantMock.getAddress()).thenReturn(defaultAddress);

        alternateDestinationFinder = new AlternateDestinationFinderImpl(serviceDescriptorMock);
    }

    @Test
    public void getAlternateDestination_noRedirectNumberInDao() throws Exception
    {
        when(serviceDataMock.getServiceAttribute(defaultAddress, redirectNumberAttribute)).thenReturn(null);

        assertEquals(defaultAddress, alternateDestinationFinder.getAlternateDestination(calledParticipantMock));
    }

    @Test
    public void getAlternateDestination_redirectNumberInDao() throws Exception
    {
        final String administeredDestination = "+17205551212";

        when(serviceDataMock.getServiceAttribute(defaultAddress, redirectNumberAttribute))
                .thenReturn(administeredDestination);

        assertEquals(administeredDestination,
                alternateDestinationFinder.getAlternateDestination(calledParticipantMock));
    }
}
