package com.avaya.zephyr.services.dynamicteamformation.email;

import static org.easymock.EasyMock.anyObject;
import static org.easymock.EasyMock.expect;
import static org.powermock.api.easymock.PowerMock.createMock;
import static org.powermock.api.easymock.PowerMock.replayAll;
import static org.powermock.api.easymock.PowerMock.verifyAll;

import java.util.ArrayList;
import java.util.Arrays;

import org.junit.Before;
import org.junit.Test;

import com.avaya.collaboration.email.EmailRequest;
import com.avaya.collaboration.email.EmailResponse;
import com.avaya.collaboration.util.logger.Logger;

public class DynamicTeamFormationEmailListenerTest
{
    private DynamicTeamFormationEmailListener mockDynamicTeamFormationEmailListener;
    private EmailRequest mockEmailRequest;
    private EmailResponse mockEmailResponse;
    private Logger mockLogger;

    @Before
    public void setUpMockCommon() throws Exception
    {
        mockEmailRequest = createMock(EmailRequest.class);
        mockEmailResponse = createMock(EmailResponse.class);
        mockLogger = createMock(Logger.class);
        mockDynamicTeamFormationEmailListener =
                new DynamicTeamFormationEmailListener(mockEmailRequest, mockLogger);
    }

    private void setupMockEmailRequest()
    {
        expect(mockEmailRequest.getTo()).andReturn(new ArrayList<String>(
                Arrays.asList("to@domain.com")));
        expect(mockEmailRequest.getCc()).andReturn(new ArrayList<String>(
                Arrays.asList("cc@domain.com")));
        expect(mockEmailRequest.getBcc()).andReturn(new ArrayList<String>(
                Arrays.asList("bcc@domain.com")));
        expect(mockEmailRequest.getSubject()).andReturn("subject");
        expect(mockEmailRequest.getTextBody()).andReturn("body");
    }

    private void setupMockEmailResponse()
    {
        expect(mockEmailResponse.getInvalidAddresses()).andReturn(new ArrayList<String>(
                Arrays.asList("invalid@domain.com")));
        expect(mockEmailResponse.getValidUnsentAddresses()).andReturn(new ArrayList<String>(
                Arrays.asList("validUnsent@domain.com")));
        expect(mockEmailResponse.getValidSentAddresses()).andReturn(new ArrayList<String>(
                Arrays.asList("validSent@domain.com")));
        expect(mockEmailResponse.getStatus()).andReturn(5);
        expect(mockEmailResponse.getDetail()).andReturn("detail");
    }

    @Test
    public void testResponseReceived() throws Exception
    {
        // Test Info

        // Test Data

        // Setup mocks
        setupMockEmailRequest();
        setupMockEmailResponse();
        mockLogger.info((String) anyObject());

        // Replay, Execute, and Verify
        replayAll();
        mockDynamicTeamFormationEmailListener.responseReceived(mockEmailResponse);
        verifyAll();
    }

}
