///////////////////////////////////////////////////////////////////////////////
//// HelloServiceListener.java
////
//// Copyright 2013 Avaya Inc. All rights reserved.
//// Usage of this source is bound to the terms described
//// in http://www.avaya.com/devconnect
//// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or Avaya Policy.
/////////////////////////////////////////////////////////////////////////////////

package com.avaya.zephyr.services.helloservice;

import com.avaya.collaboration.call.Call;
import com.avaya.collaboration.call.CallListenerAbstract;
import com.avaya.collaboration.call.Participant;
import com.avaya.collaboration.call.TheCallListener;

import com.avaya.collaboration.dal.factory.CollaborationDataFactory;
import com.avaya.collaboration.util.logger.Logger;
import com.avaya.collaboration.businessdata.api.ServiceData;

import com.avaya.zephyr.platform.dal.api.ServiceDescriptor;
import com.avaya.zephyr.platform.dal.api.ServiceUtil;

@TheCallListener
public class HelloServiceListener extends CallListenerAbstract
{

    public static final String DEFAULT_DISPLAY = "HELLO WORLD!";

    private ServiceData svcData;
    private Logger logger;

    // Public constructor injects default dependencies.
    public HelloServiceListener()
    {

        ServiceDescriptor svc = ServiceUtil.getServiceDescriptor();
        if (svc == null)
        {
            throw new IllegalStateException("Couldn't get service descriptor");
        }
        this.logger = Logger.getLogger(HelloServiceListener.class);
        this.svcData = CollaborationDataFactory.getServiceData(svc.getName(), svc.getVersion());

    }

    // Protected constructor for dependency injection in unit tests.
    protected HelloServiceListener(final ServiceData svcData, final Logger logger)
    {
        this.logger = logger;
        this.svcData = svcData;
    }

    @Override
    public final void callIntercepted(final Call call)
    {

        Participant callingParty = call.getCallingParty();
        Participant calledParty = call.getCalledParty();

        // Log a message on entering the service.
        logger.info(String.format("Call from %s to %s entered Hello World Service",
                callingParty.getHandle(), calledParty.getHandle()));

        // Fetch a display string from the calling party's Service Profile.
        // Use the default if one isn't available.
        String displayFromServiceProfile = null;
        if (call.isCallingPhase())
        {

            try
            {
                displayFromServiceProfile =
                        svcData.getServiceAttribute(callingParty.getAddress(), "displayString");
            }
            catch (Exception e)
            {
                logger.error("Exception while looking up user ", e);
            }

        }
        else
        {

            try
            {
                displayFromServiceProfile =
                        svcData.getServiceAttribute(calledParty.getAddress(), "displayString");
            }
            catch (Exception e)
            {
                logger.error("Exception while looking up user ", e);
            }

        }
        if (displayFromServiceProfile != null)
        {
            callingParty.setPresentedDisplayName(displayFromServiceProfile);
        }
        else
        {
            callingParty.setPresentedDisplayName(DEFAULT_DISPLAY);
        }

        // Allow the call to proceed.
        call.allow();
    }
}
