package com.avaya.zephyr.services.sample_services.Authorization.util;

import com.avaya.zephyr.platform.dal.api.ServiceUtil;

public enum ServiceAttributeDefaults
{
    ENABLE_TOKENLESS_ACCESS("com.avaya.authorization.enableTokenlessAccess", "false"),
    SESSION_COOKIE_NAME("com.avaya.authorization.sessionCookieName", "UserSession"),
    CLIENT_REDIRECTION_PATH("com.avaya.authorization.clientRedirectionPath",
            "/services/" + ServiceUtil.getServiceDescriptor().getName() + "/");

    private final String attributeName;
    private final String defaultValue;

    private ServiceAttributeDefaults(final String attributeName, final String defaultValue)
    {
        this.attributeName = attributeName;
        this.defaultValue = defaultValue;
    }

    public String getAttributeName()
    {
        return attributeName;
    }

    public String getDefaultValue()
    {
        return defaultValue;
    }
}