/*****************************************************************************
 * © 2015 Avaya Inc. All rights reserved.
 ****************************************************************************/
package com.avaya.zephyr.services.sample_services.CallableService.operations;

import com.avaya.collaboration.call.Call;
import com.avaya.collaboration.call.Participant;
import com.avaya.collaboration.call.media.DigitOptions;
import com.avaya.collaboration.call.media.MediaFactory;
import com.avaya.collaboration.call.media.MediaService;
import com.avaya.collaboration.call.media.PlayItem;
import com.avaya.collaboration.util.logger.Logger;
import com.avaya.zephyr.services.sample_services.CallableService.PromptsToPlay;
import com.avaya.zephyr.services.sample_services.CallableService.menus.CallableServiceMainMenuMediaListener;
import com.avaya.zephyr.services.sample_services.CallableService.menus.CallableServiceSubMenuMediaListener;
import com.avaya.zephyr.services.sample_services.CallableService.util.CallableServiceUtil;

public final class PromptAndCollectOperationImpl implements PromptAndCollectOperation
{
    private final CallableServiceUtil callableServiceUtil;
    private final Logger logger;
    private static final int maxCollectDuration = 60000;

    public PromptAndCollectOperationImpl()
    {
        this(new CallableServiceUtil(), Logger.getLogger(PromptAndCollectOperationImpl.class));
    }

    PromptAndCollectOperationImpl(final CallableServiceUtil callableServiceUtil, final Logger logger)
    {
        this.callableServiceUtil = callableServiceUtil;
        this.logger = logger;
    }

    @Override
    public void executePromptAndCollectOperation(final Call call, final PromptsToPlay promptToPlay)
    {
        logger.finer("PromptAndCollectOperationImpl executePromptAndCollectOperation ENTER");
        final DigitOptions digitOptions = setDigitOptions();
        final PlayItem playItem = setPlayItem();
        try
        {
            final StringBuffer source = new StringBuffer();
            source.append(callableServiceUtil.buildUri()).append(promptToPlay.getTitle());
            logger.finer("PromptAndCollectOperationImpl executePromptAndCollectOperation setSource: " +
                    source.toString());
            playItem.setSource(source.toString());
        }
        catch (final Exception e)
        {
            logger.error("PromptAndCollectOperationImpl executePromptAndCollectOperation: exception=", e);
            call.drop();
        }
        callableServiceUtil.writeLog(PromptAndCollectOperationImpl.class, call, digitOptions, playItem,
                logger);
        promptAndCollect(call, digitOptions, playItem, promptToPlay);
        logger.finer("PromptAndCollectOperationImpl executePromptAndCollectOperation EXIT");
    }

    private static DigitOptions setDigitOptions()
    {
        final DigitOptions setDigitOptions = MediaFactory.createDigitOptions();
        setDigitOptions.setNumberOfDigits(1);
        setDigitOptions.setTerminationKey("#");
        setDigitOptions.setTimeout(maxCollectDuration);
        return setDigitOptions;
    }

    private static PlayItem setPlayItem()
    {
        final PlayItem setPlayItem = MediaFactory.createPlayItem();
        setPlayItem.setInterruptible(true);
        setPlayItem.setIterateCount(1);
        return setPlayItem;
    }

    private void promptAndCollect(final Call call, final DigitOptions digitOptions, final PlayItem playItem,
            final PromptsToPlay promptToPlay)
    {
        logger.finer("PromptAndCollectOperationImpl promptAndCollect ENTER");
        final MediaService mediaService = MediaFactory.createMediaService();
        final CallableServiceSubMenuMediaListener callableServiceSubMenuMediaListener =
                new CallableServiceSubMenuMediaListener(call);
        final CallableServiceMainMenuMediaListener callableServiceMainMenuMediaListener =
                new CallableServiceMainMenuMediaListener(call);
        final Participant participant = call.getCallingParty();

        if ((promptToPlay == PromptsToPlay.APPROVE_OR_DISCARD) ||
                (promptToPlay == PromptsToPlay.RETURN_TO_MAINMENU))
        {
            logger.finer("PromptAndCollectOperationImpl promptAndCollect with CallableServiceSubMenuMediaListener");
            mediaService.promptAndCollect(participant, playItem, digitOptions,
                    callableServiceSubMenuMediaListener);
        }
        else
        {
            logger.finer("PromptAndCollectOperationImpl promptAndCollect with CallableServiceMainMenuMediaListener");
            mediaService.promptAndCollect(participant, playItem, digitOptions,
                    callableServiceMainMenuMediaListener);
        }
        logger.finer("PromptAndCollectOperationImpl promptAndCollect EXIT");
    }
}
