package com.avaya.zephyr.services.sample_services.CallableService.attributeReaders;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.powermock.modules.junit4.PowerMockRunner;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;
import com.avaya.asm.datamgr.AssetDM;
import com.avaya.collaboration.util.logger.Logger;
@RunWith(PowerMockRunner.class)
public class TrafficInterfaceAddressRetrieverImplTest {
	
	TrafficInterfaceAddressRetrieverImpl trafficInterfaceAddressRetrieverImpl;
	
	@Mock
	private AssetDM assetDM;
	
	@Mock
	private Logger logger;
	
	@Before
	public void setUp()
	{
		trafficInterfaceAddressRetrieverImpl = new TrafficInterfaceAddressRetrieverImpl(assetDM, logger);
	}
	
	@Test
	public void getTrafficInterfaceAddress()
	{
		when(logger.isFinestEnabled()).thenReturn(true);
		trafficInterfaceAddressRetrieverImpl.getTrafficInterfaceAddress();
		verify(assetDM).getMyAssetIp();
		when(logger.isFinestEnabled()).thenReturn(false);
		trafficInterfaceAddressRetrieverImpl.getTrafficInterfaceAddress();
	}
}
