/////////////////////////////////////////////////////////////////////////////
//Copyright Avaya Inc., All Rights Reserved
// THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AVAYA INC
// The copyright notice above does not evidence any
// actual or intended publication of such source code.
// Some third-party source code components may have been modified from
// their original versions by Avaya Inc.
// The modifications are Copyright Avaya Inc., All Rights Reserved.
//////////////////////////////////////////////////////////////////////////////
package com.avaya.services.whitelist.db;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.openjpa.persistence.DataCache;

@Entity(name = "WHITELIST")
@DataCache(timeout = CacheValues.DEFAULT_EVICTION_TIMEOUT_IN_MILLISECONDS)
@Table(name = "WHITELIST")
@NamedQueries(
{
        @NamedQuery(
                name = NamedQueriesList.FIND_WHITELIST_ENTRY,
                query = "SELECT c FROM WHITELIST c " +
                        "WHERE c.calledHandle= :calledNumber and c.callingHandle= :callingNumber"),

        @NamedQuery(name = NamedQueriesList.FIND_WHITELIST_ENTRIES,
                query = "SELECT c FROM WHITELIST c")
})
public class WhiteListEntry implements Serializable
{
    private static final long serialVersionUID = 5884606347497301292L;

    @Id
    @Column(name = "ID", nullable = false)
    @SequenceGenerator(name = "whitelist_id_seq", sequenceName = "whitelist_id_seq", allocationSize = 1)
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "whitelist_id_seq")
    private long id;

    @Column(name = "CALLED_HANDLE")
    private String calledHandle;

    @Column(name = "CALLING_HANDLE")
    private String callingHandle;

    public WhiteListEntry()
    {
    }

    public String getCalledHandle()
    {
        return calledHandle;
    }

    public void setCalledHandle(final String calledHandle)
    {
        this.calledHandle = calledHandle;
    }

    public String getCallingHandle()
    {
        return callingHandle;
    }

    public void setCallingHandle(final String callingHandle)
    {
        this.callingHandle = callingHandle;
    }

    @Override
    public boolean equals(final Object thatObject)
    {
        if (!(thatObject instanceof WhiteListEntry))
        {
            return false;
        }

        final WhiteListEntry that = (WhiteListEntry) thatObject;

        return new EqualsBuilder().append(calledHandle, that.getCalledHandle()).
                append(callingHandle, that.getCallingHandle()).
                isEquals();
    }

    @Override
    public int hashCode()
    {
        return new HashCodeBuilder().append(calledHandle).append(callingHandle).hashCode();
    }

    @Override
    public String toString()
    {
        return "WhiteListEntry [calledHandle=" + calledHandle
                + ", callingHandle=" + callingHandle + "]";
    }
}
