/****************************************************************************
* Copyright Avaya Inc., All Rights Reserved.
* THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
* The copyright notice above does not evidence any actual or intended publication of such source code.
* Some third-party source code components may have been modified from their original versions by Avaya Inc.
* The modifications are Copyright Avaya Inc., All Rights Reserved.
* Avaya Confidential & Restricted. May not be distributed further without written permission of
* the Avaya owner.
****************************************************************************/
package com.avaya.zephyr.services.sample_services.Authorization.TaskRepository.holder;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

import com.avaya.zephyr.services.sample_services.Authorization.TaskRepository.json.Task;

@RunWith(MockitoJUnitRunner.class)
public final class TaskHolderTest
{
    TaskHolder taskHolder;

    @Before
    public void before()
    {
        taskHolder = TaskHolder.getInstance();
    }

    @Test
    public void getTasksByUserId_wrongUser_emptyList()
    {
        List<Task> list = taskHolder.getTasksByUserId("invalid_user");
        assertNotNull(list);
        assertEquals(0, list.size());
    }

    @Test
    public void getTasksByUserId_validUser_taskList()
    {
        Task task = new Task("taskId", "userId", "title", "description", false,
                new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format(new Date()));
        taskHolder.addTask(task);
        List<Task> list = taskHolder.getTasksByUserId("userId");
        taskHolder.deleteTask("userId", "taskId");
        assertNotNull(list);
        assertEquals(1, list.size());
    }

    @Test
    public void addTask_NullUser_taskNotAdded()
    {
        taskHolder.addTask(null);
        List<Task> allTasks = taskHolder.getAllTasks();
        // Size should be one because there is one dummy task
        assertNotNull(allTasks.size());
    }

    @Test
    public void addTask_ValidUser_taskAdded()
    {
        Task task = new Task("taskId", "userId", "title", "description", false,
                new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format(new Date()));
        taskHolder.addTask(task);
        List<Task> list = taskHolder.getTasksByUserId("userId");
        taskHolder.deleteTask("userId", "taskId");
        assertNotNull(list);
        assertEquals(1, list.size());
    }

    @Test
    public void deleteTask_NullUser_taskNotDeleted()
    {
        boolean deleted = taskHolder.deleteTask(null, "taskId");
        assertFalse(deleted);
    }

    @Test
    public void deleteTask_NoTaskToDelete_taskNotDeleted()
    {
        boolean deleted = taskHolder.deleteTask("userId", "taskId");
        assertFalse(deleted);
    }

    @Test
    public void deleteTask_ValidUserValidTask_taskDeleted()
    {
        Task task = new Task("taskId", "userId", "title", "description", false,
                new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format(new Date()));
        taskHolder.addTask(task);
        boolean deleted = taskHolder.deleteTask("userId", "taskId");
        assertTrue(deleted);
    }

    @Test
    public void updateTask_NullTask_taskNotUpdated()
    {
        Task updateTask = taskHolder.updateTask(null);
        assertNull(updateTask);
    }

    @Test
    public void updateTask_NoTaskToUpdate_taskNotUpdated()
    {
        Task task = new Task("taskId", "userId", "title", "description", false,
                new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format(new Date()));
        Task updateTask = taskHolder.updateTask(task);
        assertNull(updateTask);
    }

    @Test
    public void updateTask_TaskToUpdate_taskUpdated()
    {
        Task task = new Task("taskId", "userId", "title", "description", false,
                new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format(new Date()));
        taskHolder.addTask(task);
        List<Task> list = taskHolder.getTasksByUserId("userId");
        String description = list.get(0).getDescription();
        Task taskToUpdate = new Task("taskId", "userId", "title", "updated-description", false,
                new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format(new Date()));
        Task updateTask = taskHolder.updateTask(taskToUpdate);
        List<Task> updatedList = taskHolder.getTasksByUserId("userId");
        String updatedDescription = updatedList.get(0).getDescription();
        taskHolder.deleteTask("userId", "taskId");
        assertNotNull(updateTask);
        assertEquals("description", description);
        assertEquals("updated-description", updatedDescription);
    }
}
