/*****************************************************************************
 * © 2017 Avaya Inc. All rights reserved.
 ****************************************************************************/
package com.avaya.services.CallDeflection;

import java.util.UUID;

import com.avaya.collaboration.call.Call;
import com.avaya.collaboration.call.media.DigitCollectorOperationCause;
import com.avaya.collaboration.call.media.MediaListenerAbstract;
import com.avaya.collaboration.call.media.PlayOperationCause;
import com.avaya.collaboration.util.logger.Logger;

public final class CallDeflectionMediaListener extends MediaListenerAbstract
{
    private static final int PROMPT4 = 4;
    private static final int PROMPT3 = 3;
    private static final int PROMPT2 = 2;
    public static final int PROMPT1 = 1;
    public static final String DIGIT3 = "3";
    public static final String DIGIT2 = "2";
    public static final String DIGIT1 = "1";

    private final CallDeflectionOperations operation;
    private final Call call;
    private final CallDeflectionMediaOperations callDeflectionMediaOperations;
    private final Logger logger;

    public CallDeflectionMediaListener(final Call call, final CallDeflectionMediaOperations callDeflectionMediaOperations)
    {
        this(call, new CallDeflectionOperationsImpl(), callDeflectionMediaOperations, Logger.getLogger(CallDeflectionMediaListener.class));
    }

    CallDeflectionMediaListener(final Call call, final CallDeflectionOperations operation,
            final CallDeflectionMediaOperations callDeflectionMediaOperations, final Logger logger)
    {
        this.call = call;
        this.operation = operation;
        this.callDeflectionMediaOperations = callDeflectionMediaOperations;
        this.logger = logger;
    }

    @Override
    public void digitsCollected(final UUID requestId, final String collectDigits,
            final DigitCollectorOperationCause cause)
    {
        if (logger.isFinerEnabled())
        {
            logger.finer("digitsCollected ENTER " + collectDigits);
        }

        try
        {
            if (callDeflectionMediaOperations.getPromptNumber() == PROMPT1)
            {
                prompt1(collectDigits);
            }
            else
            {
                prompt2(collectDigits);
            }
        }
        catch (final Exception e)
        {
            logger.error("digitsCollected: failed operation exception=", e);
            operation.dropCall(call);
        }
        logger.finer("digitsCollected EXIT ");
    }

    private void prompt2(final String collectDigits)
    {
        switch (collectDigits)
        {
            case DIGIT1:
                // prompt 2 and digit=1, SMS
                callDeflectionMediaOperations.executePlayOperation(call, PROMPT3);
                break;
            case DIGIT2:
                // prompt2 and digit=2, EMAIL
                callDeflectionMediaOperations.executePlayOperation(call, PROMPT4);
                break;
            case DIGIT3:
                // prompt2 and digit=3
                operation.addPartyToCall(call);
                break;
            default:
                logger.warn("digitsCollected: invalid digit=" + collectDigits);
                operation.dropCall(call);
                break;
        }
    }

    private void prompt1(final String collectDigits)
    {
        switch (collectDigits)
        {
            case DIGIT1:
                callDeflectionMediaOperations.executePromptAndCollectOperation(call, PROMPT2);
                break;
            case DIGIT2:
                // prompt1 and digit=2
                operation.addPartyToCall(call);
                break;
            default:
                logger.warn("digitsCollected: invalid digit=" + collectDigits);
                operation.dropCall(call);
                break;
        }
    }

    @Override
    public void playCompleted(final UUID requestId, final PlayOperationCause cause)
    {
        logger.finer("playCompleted ENTER ");
        if (callDeflectionMediaOperations.getPromptNumber() == PROMPT3)
        {
            logger.finer("playCompleted sendSMS ");
            // prompt 2 and digit=1, SMS
            operation.sendSms(call);
            operation.dropCall(call);
        }
        if (callDeflectionMediaOperations.getPromptNumber() == PROMPT4)
        {
            logger.finer("playCompleted sendEmail ");
            // prompt2 and digit=2, EMAIL
            operation.sendEmail();
            operation.dropCall(call);
        }
        logger.finer("playCompleted EXIT ");
    }
}
