/*****************************************************************************
 * © 2017 Avaya Inc. All rights reserved.
 ****************************************************************************/
package com.avaya.services.CallDeflection.email;

import java.util.List;

import com.avaya.collaboration.email.EmailListener;
import com.avaya.collaboration.email.EmailRequest;
import com.avaya.collaboration.email.EmailResponse;
import com.avaya.collaboration.util.logger.Logger;

public final class CallDeflectionEmailListener implements EmailListener
{
    private final Logger logger;
    private EmailRequest emailRequest = null;

    public CallDeflectionEmailListener(final EmailRequest emailRequest)
    {
        this.emailRequest = emailRequest;
        logger = Logger.getLogger(CallDeflectionEmailListener.class);
    }

    public CallDeflectionEmailListener(final EmailRequest emailRequest, final Logger logger)
    {
        this.emailRequest = emailRequest;
        this.logger = logger;
    }

    private StringBuilder createCommaSeparatedFromList(final List<String> inputList)
    {
        final StringBuilder commaSeperatedValues = new StringBuilder();
        for (final String commaValue : inputList)
        {
            if (commaSeperatedValues.length() > 0)
            {
                commaSeperatedValues.append(",");
            }
            commaSeperatedValues.append(commaValue);
        }
        return commaSeperatedValues;

    }

    @Override
    public void responseReceived(final EmailResponse emailResponse)
    {
        // Create comma separated recipients in To header
        final StringBuilder sbRequestTos = createCommaSeparatedFromList(emailRequest.getTo());

        // Create comma separated invalid recipients
        final StringBuilder sbInvalidAddresses = createCommaSeparatedFromList(emailResponse.getInvalidAddresses());

        // Create comma separated valid unsent recipients
        final StringBuilder sbValidUnsentAddresses = createCommaSeparatedFromList(emailResponse.getValidUnsentAddresses());

        // Create comma separated valid sent recipients
        final StringBuilder sbValidSentAddresses = createCommaSeparatedFromList(emailResponse.getValidSentAddresses());

        // Create a String which holds the email response
        final String emailResponseToString =
                "emailResponse[" + " Status= " + emailResponse.getStatus() +
                        (sbInvalidAddresses.length() == 0 ? ""
                                : " InvalidAddresses=" + sbInvalidAddresses.toString()) +
                        (sbValidUnsentAddresses.length() == 0 ? ""
                                : " ValidUnsentAddresses=" + sbValidUnsentAddresses.toString()) +
                        (sbValidSentAddresses.length() == 0 ? ""
                                : " ValidSentAddresses=" + sbValidSentAddresses.toString()) +
                        " Detail= " + emailResponse.getDetail() + " ]";

        // Create a String which holds the email request with To headers
        final String emailRequestToString = "emailRequest[" +
                (sbRequestTos.length() == 0 ? "" : " To=" + sbRequestTos.toString()) +
                ", Subject=" + emailRequest.getSubject() + " Message=" +
                emailRequest.getTextBody() + " ]";

        final String responseReceivedLogString =
                "responseReceived: " + emailResponseToString + " for " + emailRequestToString;

        logger.info(responseReceivedLogString);
    }
}
