/*****************************************************************************
 * © 2015 Avaya Inc. All rights reserved.
 ****************************************************************************/
package com.avaya.services.Callingpolicies;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;
import static org.mockito.Mockito.doThrow;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import com.avaya.zephyr.platform.dao.ClusterAttributeDAO;
import com.avaya.collaboration.businessdata.api.NoAttributeFoundException;
import com.avaya.collaboration.util.logger.Logger;

@RunWith(MockitoJUnitRunner.class)
public class ClusterAttributeReaderImplTest
{
    private static final String LOG_BGN = "getAnnouncementFileNetworkProtocol: security=";
    private static final String LOG_BGN_DMN = "getDefaultClusterDomain: sip default domain=";
    private static final String DFLT_PROT = "https";
    private static final String OTHER_PROT = "http";
    private static final String DFLT_DMN = "avaya.com";
    @Mock
    private ClusterAttributeDAO mClustrAttrDAO;
    @Mock
    private ClusterAttributeReader clustrAttrRdr, mClustrAttrRdr;
    @Mock
    private Logger logger;

    @Before
    public void setUp() throws Exception
    {
        clustrAttrRdr = new ClusterAttributeReaderImpl(mClustrAttrDAO, logger);
        when(logger.isFinestEnabled()).thenReturn(true);
    }

    @Test
    public void getAnnouncementFileNetworkProtocol_Https() throws Exception
    {
        when(mClustrAttrDAO.getClusterAttribute("HttpsOnly")).thenReturn("true");
        final String https = mClustrAttrDAO.getClusterAttribute("HttpsOnly");
        final String isHttps = clustrAttrRdr.getAnnouncementFileNetworkProtocol();

        verify(logger).isFinestEnabled();
        verify(logger).finest(LOG_BGN + https);
        assertEquals(DFLT_PROT, isHttps);
    }

    @Test
    public void getAnnouncementFileNetworkProtocol_Http() throws Exception
    {
        when(mClustrAttrDAO.getClusterAttribute("HttpsOnly")).thenReturn("false");
        final String http = mClustrAttrDAO.getClusterAttribute("HttpsOnly");
        final String isHttp = clustrAttrRdr.getAnnouncementFileNetworkProtocol();

        verify(logger).isFinestEnabled();
        verify(logger).finest(LOG_BGN + http);
        assertEquals(OTHER_PROT, isHttp);
    }

    @Test
    public void getDefaultClusterDomain_Success() throws Exception
    {
        when(mClustrAttrDAO.getClusterAttribute("SIPDefaultDomain")).thenReturn("avaya.com");
        final String mockDomain = mClustrAttrDAO.getClusterAttribute("SIPDefaultDomain");
        final String domain = clustrAttrRdr.getDefaultClusterDomain();

        verify(logger).isFinestEnabled();
        verify(logger).finest(LOG_BGN_DMN + mockDomain);
        assertEquals(DFLT_DMN, domain);
    }

    @Test(expected = NoAttributeFoundException.class)
    public void getDefaultClusterDomain_No_Attr() throws Exception
    {
        final NoAttributeFoundException noAttr = new NoAttributeFoundException("no attr found");
        doThrow(noAttr).when(mClustrAttrDAO).getClusterAttribute("SIPDefaultDomain");
        doThrow(noAttr).when(mClustrAttrRdr).getDefaultClusterDomain();

        fail(clustrAttrRdr.getDefaultClusterDomain());
    }
}
