/*****************************************************************************
 * © 2017 Avaya Inc. All rights reserved.
 ****************************************************************************/
package com.avaya.services.CallDeflection.sms;

import org.apache.commons.lang3.StringUtils;

import com.avaya.collaboration.businessdata.api.NoAttributeFoundException;
import com.avaya.collaboration.businessdata.api.NoServiceProfileFoundException;
import com.avaya.collaboration.businessdata.api.NoUserFoundException;
import com.avaya.collaboration.businessdata.api.ServiceNotFoundException;
import com.avaya.collaboration.call.Call;
import com.avaya.collaboration.sms.SmsFactory;
import com.avaya.collaboration.sms.SmsRequest;
import com.avaya.collaboration.util.logger.Logger;
import com.avaya.services.CallDeflection.util.ServiceAttributeReader;
import com.avaya.services.CallDeflection.util.ServiceAttributeReaderImpl;

public class CallDeflectionSmsSender
{
    private static final String CALL_DEFLECTION_DEMO = "CallDeflection Demo";
    private static final String SMS_INFO_SENT_LOG = "Info: SMS queued to be sent to ";
    private static final String SMS_INFO_NOT_SENT_LOG = "Info:  SMS Body is blacnk SMS will not be sent.";
    private static final String SMS_TO_NOT_SENT_LOG = "Info: SMS To is blacnk,  SMS will not be sent";
    private static final String SMS_ERROR_SEND_LOG = "Error: Error occured sending SMS.";

    private final Logger logger;
    private final ServiceAttributeReader serviceAttributeReader;

    public CallDeflectionSmsSender()
    {
        this(new ServiceAttributeReaderImpl(), Logger.getLogger(CallDeflectionSmsSender.class));
    }

    public CallDeflectionSmsSender(final ServiceAttributeReader serviceAttributeReader, final Logger logger)
    {
        this.serviceAttributeReader = serviceAttributeReader;
        this.logger = logger;
    }

    public final boolean sendSms(final Call call)
            throws NoAttributeFoundException, ServiceNotFoundException, NoUserFoundException, NoServiceProfileFoundException
    {
        boolean smsSent = false;

        String smsTo = serviceAttributeReader.getSmsTo();
        final String smsBody = CALL_DEFLECTION_DEMO;

        if (StringUtils.isBlank(smsBody))
        {
            logger.info(SMS_INFO_NOT_SENT_LOG);
        }
        else
        {
            if (StringUtils.isBlank(smsTo))
            {
                smsTo = call.getCallingParty() != null ? call.getCallingParty().getHandle() : null;
            }
            final String smsFrom = serviceAttributeReader.getSmsFrom();
            if (StringUtils.isBlank(smsTo))
            {
                logger.info(SMS_TO_NOT_SENT_LOG);
            }
            else
            {
                final SmsRequest smsRequest = SmsFactory.createSmsRequest(smsTo, smsBody);
                if (!smsFrom.isEmpty())
                {
                    smsRequest.setSender(smsFrom);
                }

                // Create the listener and send the sms message
                final CallDeflectionSmsListener smsListener = new CallDeflectionSmsListener(smsRequest);
                smsRequest.setListener(smsListener);

                try
                {
                    smsRequest.send();
                    logSendSuccess(smsRequest);
                    smsSent = true;
                }
                catch (final Exception e)
                {
                    logger.error(SMS_ERROR_SEND_LOG, e);
                }
            }
        }
        return smsSent;
    }

    private void logSendSuccess(final SmsRequest smsRequest)
    {
        final StringBuilder sbSmsAddresses = new StringBuilder();
        for (final String smsTo : smsRequest.getRecipients())
        {
            if (sbSmsAddresses.length() == 0)
            {
                sbSmsAddresses.append(smsTo);
            }
            else
            {
                sbSmsAddresses.append(", ").append(smsTo);
            }
        }

        logger.info(SMS_INFO_SENT_LOG + sbSmsAddresses.toString());
    }
}
