/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.common.logging.helper;

import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class ResourceBundleLoader {
    static HashMap<String, ResourceBundle> resourceBundles = new HashMap();
    static HashMap<String, Long> fileModificationTimes = new HashMap();
    ResourceBundle rBundle = null;
    URL urlResource = null;
    String resourceProtocol = "";
    String resourceFilename = "";
    long modificationTime = -1L;

    public ResourceBundle load(String string) {
        String string2 = this.formatResourceName(string);
        this.getResource(string2);
        this.rBundle = resourceBundles.get(string2);
        if (this.rBundle == null) {
            this.loadResource(string2);
        } else if (this.resourceProtocol.equals("file")) {
            Long l;
            File file = new File(this.resourceFilename);
            if (file.exists() && file.canRead()) {
                this.modificationTime = file.lastModified();
            }
            if ((l = fileModificationTimes.get(string2)) == null || this.modificationTime > l) {
                this.loadResource(string2);
            }
        }
        return this.rBundle;
    }

    private String formatResourceName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string.replace('.', '/')).append(".properties");
        return stringBuffer.toString();
    }

    private void getResource(String string) {
        this.urlResource = this.getClass().getClassLoader().getResource(string);
        this.resourceProtocol = this.urlResource.getProtocol();
        try {
            this.resourceFilename = URLDecoder.decode(this.urlResource.getFile(), "UTF-16");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadResource(String string) {
        try {
            this.rBundle = new PropertyResourceBundle(this.getClass().getClassLoader().getResourceAsStream(string));
        }
        catch (Exception exception) {
            // empty catch block
        }
        resourceBundles.put(string, this.rBundle);
        if (this.urlResource.getProtocol().equals("file")) {
            if (this.modificationTime == -1L) {
                File file = new File(this.resourceFilename);
                this.modificationTime = file.lastModified();
            }
            fileModificationTimes.put(string, this.modificationTime);
        }
    }

    public static void main(String[] stringArray) {
        ResourceBundleLoader resourceBundleLoader = new ResourceBundleLoader();
        resourceBundleLoader.load("com.avaya.EventCodes");
    }
}

