/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.common.testutils;

import com.avaya.common.logging.client.Logger;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.junit.Assert;

public class TestProperties {
    private static final Logger log = Logger.getLogger(TestProperties.class);
    private Object testBean;
    private HashMap<String, Object> registeredSetterArgs = new HashMap();
    private final HashMap<String, Method> beanGetters = new HashMap();
    private final HashMap<String, Method> beanSetters = new HashMap();
    private final TreeSet<String> beanProperties = new TreeSet();
    private final TreeSet<String> beanPropertiesThatWereTested = new TreeSet();
    private final TreeSet<String> beanPropertiesToIgnore = new TreeSet();
    private final Random rand = new Random();
    private Class<?>[] supportedSetterParmTypesForAutoGenerateValue = new Class[]{Integer.TYPE, Integer.class, Long.class, Long.TYPE, String.class, Set.class, Map.class, List.class, Object.class, Boolean.class, Boolean.TYPE};

    private TestProperties() {
    }

    public static <T> TestProperties forBean(T testBean) {
        return new TestProperties().setupBean(testBean);
    }

    public static <T> TestProperties forBeansByClass(Class<?> ... beanClasses) {
        TestProperties instance = new TestProperties();
        try {
            for (Class<?> beanClass : beanClasses) {
                Object testBean = beanClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                log.info((Object)("Testing bean (" + testBean + " - auto-instantiated) for class " + beanClass.getName()));
                instance.setupBean(testBean);
                instance.now();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return instance;
    }

    private <T> TestProperties setupBean(T testBean) {
        this.rand.setSeed(42L);
        this.testBean = testBean;
        this.beanGetters.clear();
        this.beanPropertiesThatWereTested.clear();
        this.beanSetters.clear();
        this.beanProperties.clear();
        this.beanPropertiesToIgnore.clear();
        this.registeredSetterArgs.clear();
        return this;
    }

    public boolean isSupportedSetterParmTypeForAutoGenerateValue(Class<?> c) {
        for (Class<?> supportedC : this.supportedSetterParmTypesForAutoGenerateValue) {
            if (!supportedC.equals(c)) continue;
            return true;
        }
        log.fine((Object)("Class does not have built-in support for generating setter values (may will use zero-arg constructor if possible and no value override provided)" + c.getName()));
        return false;
    }

    public <T> TestProperties withValForProp(Object testVal, String propertyName) {
        String internalPropName = propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        this.registeredSetterArgs.put(internalPropName, testVal);
        return this;
    }

    public TestProperties ignoreProp(String propertyName) {
        String internalPropName = propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        this.beanPropertiesToIgnore.add(internalPropName);
        return this;
    }

    private void analyzeBean() {
        for (Method m : this.testBean.getClass().getMethods()) {
            boolean isSetter;
            String name = m.getName();
            if (!Modifier.isPublic(m.getModifiers())) continue;
            boolean isGetter = (name.startsWith("get") || name.startsWith("is")) && m.getParameterTypes().length == 0 && !m.getReturnType().equals(Void.TYPE);
            boolean bl = isSetter = name.startsWith("set") && m.getReturnType().equals(Void.TYPE) && m.getParameterTypes().length == 1;
            if (!isGetter && !isSetter) continue;
            String propertyName = name.replaceFirst("^(get|set|is)", "");
            if (propertyName.length() < 1 || this.beanPropertiesToIgnore.contains(propertyName)) {
                log.info((Object)("Ignoring property " + propertyName));
                continue;
            }
            if (isSetter && !this.registeredSetterArgs.containsKey(propertyName) && !this.isSupportedSetterParmTypeForAutoGenerateValue(m.getParameterTypes()[0])) {
                Class<?> parmType = m.getParameterTypes()[0];
                if (Modifier.isAbstract(parmType.getModifiers())) {
                    log.warn((Object)("Ignoring property " + propertyName + " since no registered test arg value and cant auto generate value due to abstract type of setter parameter"));
                    this.beanPropertiesToIgnore.add(propertyName);
                    continue;
                }
                try {
                    parmType.getConstructor(new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    log.warn((Object)("will ignore property " + propertyName + " because its argument of type " + parmType.getName() + " has no zero arg constructor and none was registered"));
                    this.beanPropertiesToIgnore.add(propertyName);
                    continue;
                }
            }
            if (isGetter) {
                if (this.beanGetters.containsKey(propertyName)) {
                    log.warn((Object)("found multiple getters for property " + propertyName + ".  Ignorining property."));
                    this.beanGetters.remove(propertyName);
                    this.beanSetters.remove(propertyName);
                    this.beanProperties.remove(propertyName);
                } else {
                    this.beanGetters.put(propertyName, m);
                }
            } else if (isSetter) {
                this.beanSetters.put(propertyName, m);
            }
            if (!this.beanSetters.containsKey(propertyName) || !this.beanGetters.containsKey(propertyName)) continue;
            this.beanProperties.add(propertyName);
        }
    }

    private <T> Object autoGenerateTestValForParmType(Class<T> type) {
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return this.rand.nextInt();
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return this.rand.nextBoolean();
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return this.rand.nextLong();
        }
        if (type.equals(String.class)) {
            return this.rand.nextGaussian() + " test string";
        }
        if (type.equals(List.class)) {
            return new ArrayList();
        }
        if (type.equals(Map.class)) {
            return new HashMap();
        }
        if (type.equals(Set.class)) {
            return new TreeSet();
        }
        if (type.equals(Object.class)) {
            return this.rand.nextBoolean() ? Long.valueOf(this.rand.nextLong()) : "a string object";
        }
        throw new IllegalStateException("no support for auto-generate setter arg value for type " + type.getName() + " - but there should be...this is a bug");
    }

    public static void testGettersAndSetters(Object testBean) {
        TestProperties.forBean(testBean).now();
    }

    public void now() {
        try {
            this.analyzeBean();
            for (String property : this.beanProperties) {
                Method setter = this.beanSetters.get(property);
                Method getter = this.beanGetters.get(property);
                if (setter == null || getter == null) {
                    throw new IllegalStateException("have a problem - getter and or setter null for property: " + property);
                }
                log.finest((Object)("Start auto-testing getter/setter for property: " + property));
                Class<?> argType = setter.getParameterTypes()[0];
                Object argVal = null;
                if (this.registeredSetterArgs.containsKey(property)) {
                    argVal = this.registeredSetterArgs.get(property);
                    log.info((Object)("Using registered argument of type " + argType.getName() + " for property '" + property + "' with value: '" + argVal + "'"));
                    setter.invoke(this.testBean, argVal);
                } else {
                    argVal = this.invokeSetterWithRandomData(setter);
                }
                Assert.assertEquals((String)("Testing setter followed by getter for property *" + property + "* failed because value returned by getter did not match setter arg. Setter arg value was " + argVal), (Object)argVal, (Object)getter.invoke(this.testBean, new Object[0]));
                log.finest((Object)("Finish auto-testing getter/setter for property: " + property));
                this.beanPropertiesThatWereTested.add(property);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        log.info((Object)("--- Successfully tested " + this.beanPropertiesThatWereTested.size() + " properties for bean of class " + this.testBean.getClass().getName() + ":"));
        if (log.isFineEnabled()) {
            log.fine((Object)Arrays.toString(this.beanPropertiesThatWereTested.toArray()));
        }
        HashSet<String> notTested = new HashSet<String>(this.beanProperties);
        notTested.removeAll(this.beanPropertiesThatWereTested);
        if (this.beanPropertiesToIgnore.size() > 0) {
            log.info((Object)"Intentionally ignoring properties:");
            log.info((Object)Arrays.toString(this.beanPropertiesToIgnore.toArray()));
        }
        if (notTested.size() > 0) {
            log.warn((Object)"*** Properties not tested: ");
            log.warn((Object)Arrays.toString(notTested.toArray()));
        }
    }

    private Object invokeSetterWithRandomData(Method setter) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        Object argVal = null;
        Class<?> argType = setter.getParameterTypes()[0];
        if (this.isSupportedSetterParmTypeForAutoGenerateValue(argType)) {
            log.finer((Object)("Auto-generating argument of type " + argType.getName() + " for test"));
            argVal = this.autoGenerateTestValForParmType(argType);
        } else {
            log.finer((Object)("Auto-generating argument of type " + argType.getName() + " by using zero-arg constructor for class " + argType.getName() + " for test with value " + argVal));
            Constructor<?> constructor = argType.getConstructor(new Class[0]);
            argVal = constructor.newInstance(new Object[0]);
        }
        log.finest((Object)("Test value is " + argVal + " of type " + argType.getName()));
        setter.invoke(this.testBean, argVal);
        return argVal;
    }

    public void invokeSettersWithRandomData() {
        try {
            for (Method setter : this.beanSetters.values()) {
                this.invokeSetterWithRandomData(setter);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private HashMap<String, Method> getBeanGetters() {
        return this.beanGetters;
    }

    public static <T> void populateBeanWithRandomData(T beanToPopulate) {
        TestProperties props = TestProperties.forBean(beanToPopulate);
        props.analyzeBean();
        props.invokeSettersWithRandomData();
    }

    public static void verifyBeansEqual(Object first, Object second) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (!first.getClass().equals(second.getClass())) {
            throw new IllegalArgumentException("The two objects given must be of the same type");
        }
        TestProperties props = TestProperties.forBean(first);
        props.analyzeBean();
        for (Map.Entry<String, Method> m : props.getBeanGetters().entrySet()) {
            Object result1 = m.getValue().invoke(first, new Object[0]);
            Object result2 = m.getValue().invoke(second, new Object[0]);
            Assert.assertEquals((String)("No match for property, " + m.getKey() + ", in " + first.getClass().getSimpleName()), (Object)result1, (Object)result2);
        }
    }
}

